package com.yeejoin.amos.fas.business.service.intfc;

import com.yeejoin.amos.fas.business.vo.PlanDetailVo;
import com.yeejoin.amos.fas.dao.entity.PlanDetail;

import java.util.List;

/**
 * @author wjk
 * @date 2021-01-14
 * 预案操作
 */
public interface ContingencyPlanService {

    /**
     * 创建
     * @param planDetail
     * @return
     */
    PlanDetailVo createPlan(PlanDetailVo planDetail);

    /**
     * 编辑
     * @param planDetail
     * @return
     */
    PlanDetailVo editPlan(PlanDetailVo planDetail);

    /**
     * 单个详情
     * @param id
     * @return
     */
    PlanDetailVo detail(Long id);

    /**
     * 启用
     * @param idList
     * @return
     */
    List<PlanDetail> activatePlan(List<Long> idList);

    /**
     * 停用
     * @param idList
     * @return
     */
    List<PlanDetail> deactivatePlan(List<Long> idList);

    /**
     * 删除
     * @param idList
     * @return
     */
    Boolean delete(List<Long> idList);
}
