package com.yeejoin.amos.fas.business.service.intfc;

import com.yeejoin.amos.fas.business.param.FmeaBindParam;
import com.yeejoin.amos.fas.business.vo.EquipmentPointVo;
import com.yeejoin.amos.fas.business.vo.EquipmentSpecificVo;
import com.yeejoin.amos.fas.dao.entity.FmeaEquipmentPoint;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;
import java.util.Map;

/**
 * @author zjw
 * @date 2020-11-04
 * 配置设备
 */

public interface EquipmentSpecificService {

    /**
     * 修改绑定项目
     * @param fmeaBindParam
     * @return
     */
    List<FmeaEquipmentPoint> upDateEquimentPoint( FmeaBindParam fmeaBindParam);

    Map<String ,Object> getAssoEquips (Long fmeaId, int pageNumber, int pageSize);
    /**
     * 查询设备指标
     * @param fmeaId
     * @param importantEquipId
     * @param equimentId
     * @param equipmentPointName
     * @return
     */
    List<EquipmentPointVo>getBindEquipment(Long fmeaId, Long importantEquipId, Long equimentId, String  equipmentPointName);

    /**
     * 查询绑定关系设备
     * @param equipmentId
     * @param fname
     * @return
     */
    Map<String , List<EquipmentSpecificVo>> getFireEquiments(String equipmentId, String fname) ;


    /**
     *  获取配置装备
     * @param name
     * @param code
     * @param pageNumber
     * @param pageSize
     * @return
     */
    Map<String ,Object> getEquipmentBySpe(String name, String code, int  pageNumber, int pageSize, String equipmentId);
}
