package com.yeejoin.amos.fas.dao.entity;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.NamedQuery;
import javax.persistence.Table;


/**
 * The persistent class for the fire_car database table.
 * 
 */
@Entity
@Table(name="f_safety_index_change_log")
@NamedQuery(name="SafetyIndexChangeLog.findAll", query="SELECT s FROM SafetyIndexChangeLog s")
public class SafetyIndexChangeLog  implements Serializable{
	private static final long serialVersionUID = 1L;

	@Id
	@GeneratedValue(strategy=GenerationType.IDENTITY)
	@Column(name = "ID",nullable=false,unique=true)
	private Long id;
	@Column(name="safety_index")
	private BigDecimal safetyIndex;
	@Column(name="collect_date")
	private Date collectDate;
	@Column(name="org_code")
	private String orgCode;
	@Column(name="remark")
	private String remark;
	
	public Long getId() {
		return id;
	}
	public void setId(Long id) {
		this.id = id;
	}
	public BigDecimal getSafetyIndex() {
		return safetyIndex;
	}
	public void setSafetyIndex(BigDecimal safetyIndex) {
		this.safetyIndex = safetyIndex;
	}
	public Date getCollectDate() {
		return collectDate;
	}
	public void setCollectDate(Date collectDate) {
		this.collectDate = collectDate;
	}
	public String getOrgCode() {
		return orgCode;
	}
	public void setOrgCode(String orgCode) {
		this.orgCode = orgCode;
	}
	public String getRemark() {
		return remark;
	}
	public void setRemark(String remark) {
		this.remark = remark;
	}
}