package com.yeejoin.amos.fas.business.controller;

import com.yeejoin.amos.fas.business.param.AlarmParam;
import com.yeejoin.amos.fas.business.param.FmeaBindParam;
import com.yeejoin.amos.fas.business.service.intfc.IRiskFactorService;
import com.yeejoin.amos.fas.business.service.intfc.IRiskSourceService;
import com.yeejoin.amos.fas.business.service.model.ContingencyDeviceStatus;
import com.yeejoin.amos.fas.business.service.model.FireEquimentDataRo;
import com.yeejoin.amos.fas.business.service.model.ProtalDataRo;
import com.yeejoin.amos.fas.core.common.request.CommonPageable;
import com.yeejoin.amos.fas.core.common.response.RiskSourceTreeResponse;
import com.yeejoin.amos.fas.core.util.CommonResponse;
import com.yeejoin.amos.fas.core.util.CommonResponseUtil;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@RestController
@RequestMapping("/api/risksource")
@Api(tags = "风险点API")
public class RiskSourceController extends BaseController {
    private final Logger log = LoggerFactory.getLogger(RiskSourceController.class);
    @Autowired
    IRiskFactorService iRiskFactorService;

    @Autowired
    IRiskSourceService riskSourceService;

    //@Authorization(ingore = true)
    @ApiOperation(httpMethod = "GET", value = "查询风险点子项", notes = "查询风险点子项")
    @RequestMapping(value = "/children/list", produces = "application/json;charset=UTF-8", method = RequestMethod.GET)
    public CommonResponse queryRiskSourceByPage() {
        return CommonResponseUtil.success(riskSourceService.queryForRegion());
    }


    //@Authorization(ingore = true)
    @ApiOperation(httpMethod = "GET", value = "三维图统计", notes = "三维图统计")
    @RequestMapping(value = "/collection3d", produces = "application/json;charset=UTF-8", method = RequestMethod.GET)
    public CommonResponse collection3d() {
        return CommonResponseUtil.success(riskSourceService.queryFor3DStatistics());
    }


    /**
     * 查询风险点RPN统计
     *
     * @return
     */
    @ApiOperation(httpMethod = "GET", value = "查询风险点RPN统计", notes = "查询风险点RPN统计")
    @RequestMapping(value = "/rpn/list", produces = "application/json;charset=UTF-8", method = RequestMethod.GET)
    public CommonResponse queryRPNReport() {
        return CommonResponseUtil.success(riskSourceService.queryRPNReport());
    }


    /**
     * 风险上升率
     *
     * @return
     */
    @ApiOperation(httpMethod = "GET", value = "风险上升率", notes = "风险上升率")
    @RequestMapping(value = "/riseuprate", produces = "application/json;charset=UTF-8", method = RequestMethod.GET)
    public CommonResponse queryForRiseUp() throws Exception {
        return CommonResponseUtil.success(riskSourceService.queryForRiseUp());
    }


    /**
     * 发生率严重度矩阵
     *
     * @return
     */
    @ApiOperation(httpMethod = "GET", value = "发生率严重度矩阵", notes = "发生率严重度矩阵")
    @RequestMapping(value = "/matrix", produces = "application/json;charset=UTF-8", method = RequestMethod.GET)
    public CommonResponse queryForMatrix() throws Exception {
        return CommonResponseUtil.success(riskSourceService.queryForMatrix());
    }

    /**
     * 获取风险点树型结构
     *
     * @return
     */
    //@Authorization(ingore = true)
    @ApiOperation(httpMethod = "GET", value = "获取风险点树型结构", notes = "获取风险点树型结构")
    @RequestMapping(value = "/riskSourceTress", produces = "application/json;charset=UTF-8", method = RequestMethod.GET)
    public CommonResponse getRiskSourceTress() {
        List<RiskSourceTreeResponse> riskSources = riskSourceService.findRiskSourceTrees();
        return CommonResponseUtil.success(getRiskSourcesTree(riskSources));
    }

    //@Authorization(ingore = true)
    @ApiOperation(httpMethod = "GET", value = "统计级别为1的风险点下面", notes = "获取风险点树型结构")
    @RequestMapping(value = "/query3DStatistics/{markerType}", produces = "application/json;charset=UTF-8", method = RequestMethod.GET)
    public CommonResponse query3DStatistics(@PathVariable(value = "markerType", required = true) String markerType) throws Exception {
        if ("riskSource".equals(markerType)) {
            return riskSourceStatistics();
        } else if ("risk".equals(markerType)) {
            return riskStatistics();
        } else if ("impEquipment".equals(markerType)) {
            return equipStatistics();
        } else if ("fireResource".equals(markerType)) {
            String[] type = {"4", "3"};
            return equipStatistics(type);
        } else if ("monitorEquipment".equals(markerType)) {
            String[] type = {"0"};
            return equipStatistics(type);
        } else if ("video".equals(markerType)) {
            String[] type = {"2"};
            return equipStatistics(type);
        }
        return CommonResponseUtil.failure("未定义类型");
    }

    //@Authorization(ingore = true)
    @ApiOperation(httpMethod = "GET", value = "统计级别为1的风险点下面", notes = "获取风险点树型结构")
    @RequestMapping(value = "/riskSourceStatistics", produces = "application/json;charset=UTF-8", method = RequestMethod.GET)
    public CommonResponse riskSourceStatistics() throws Exception {
        List<RiskSourceTreeResponse> riskSources = riskSourceService.findRiskSourceTrees();
        List<RiskSourceTreeResponse> treeRiskSources = getRiskSourcesTree(riskSources);
        return CommonResponseUtil.success(riskSourceStatistics(treeRiskSources));
    }

    //@Authorization(ingore = true)
    @ApiOperation(httpMethod = "GET", value = "统计级别为1的风险点下面设备统计", notes = "统计级别为1的风险点下面设备统计")
    @RequestMapping(value = "/equipStatistics", produces = "application/json;charset=UTF-8", method = RequestMethod.GET)
    public CommonResponse equipStatistics() throws Exception {
        List<RiskSourceTreeResponse> riskSources = riskSourceService.findRiskSourceEquipStatistics();
        List<RiskSourceTreeResponse> treeRiskSources = getRiskSourcesEquipTree(riskSources);
        return CommonResponseUtil.success(riskSourceEquipStatistics(treeRiskSources, true, 0));
    }

    //@Authorization(ingore = true)
    @ApiOperation(httpMethod = "GET", value = "统计级别为1的巡检点统计", notes = "统计级别为1的巡检点统计")
    @RequestMapping(value = "/checkPointStatistics", produces = "application/json;charset=UTF-8", method = RequestMethod.GET)
    public CommonResponse riskStatistics() throws Exception {
        List<RiskSourceTreeResponse> riskSources = riskSourceService.getCheckPointRiskSources();
        List<RiskSourceTreeResponse> treeRiskSources = getRiskSourcesEquipTree(riskSources);
        return CommonResponseUtil.success(checkPointEquipStatistics(treeRiskSources, false, 0));
    }


    private Object checkPointEquipStatistics(List<RiskSourceTreeResponse> list, boolean isLevel, int level) {
        List<Map<String, Object>> treeList = new ArrayList<Map<String, Object>>();
        if (!ObjectUtils.isEmpty(list)) {
            Map<String, Object> map = new HashMap<>();

//        	List<RiskSourceTreeResponse> firstChildrens = list.get(0).getChildren();
            list.forEach(item -> {
//        		if (!ObjectUtils.isEmpty(item.getPosition3d())) {
                Map<String, Object> itemMap = (Map<String, Object>) map.get(item.getId());
                if (ObjectUtils.isEmpty(itemMap)) {
                    itemMap = new HashMap<>();
                    itemMap.put("id", item.getId());
                    itemMap.put("key", "key" + item.getId());
                    itemMap.put("name", item.getName());
                    if (isLevel) {
                        itemMap.put("level", level);
                    } else {
                        itemMap.put("level", item.getLevel());
                    }

                    Map<String, Object> position = new HashMap<>();

                    if (!ObjectUtils.isEmpty(item.getPosition3d())) {
                        String[] pos = item.getPosition3d().split(",");
                        position.put("x", pos[0]);
                        position.put("y", pos[1]);
                        position.put("z", pos[2]);
                    }
                    Map<String, Object> rotation = new HashMap<>();
                    rotation.put("x", 0);
                    rotation.put("y", 0);
                    rotation.put("z", 0);
                    Map<String, Object> scale = new HashMap<>();
                    scale.put("x", 1);
                    scale.put("y", 1);
                    scale.put("z", 1);

                    itemMap.put("position", position);
                    itemMap.put("scale", scale);
                    itemMap.put("rotation", rotation);
                }
                List<Map> itemCountList = new ArrayList<>();
                Map<String, Object> ItemCount = new HashMap<>();
                ItemCount.put("name", "合格");
                ItemCount.put("count", getPointChildrenCount(item, "Qualified"));
                itemCountList.add(ItemCount);

                Map<String, Object> ItemCount1 = new HashMap<>();
                ItemCount1.put("name", "不合格");
                ItemCount1.put("count", getPointChildrenCount(item, "Unqualified"));
                itemCountList.add(ItemCount1);


                Map<String, Object> ItemCount2 = new HashMap<>();
                ItemCount2.put("name", "漏检");
                ItemCount2.put("count", getPointChildrenCount(item, "Omission"));
                itemCountList.add(ItemCount2);

//        			Map<String, Object> ItemCount3 = new HashMap<>();
//        			ItemCount.put("name", "合格");
//        			ItemCount3.put("count", getPointChildrenCount(item, "Unplan"));
//        			itemCountList.add(ItemCount3);

                itemMap.put("statisticsData", itemCountList);
                map.put(item.getId() + "", itemMap);
//        		}
            });
            for (String key : map.keySet()) {
                treeList.add((Map<String, Object>) map.get(key));
            }

        }

        return treeList;
    }

    private static int getPointChildrenCount(RiskSourceTreeResponse riskSource, String status) {
        if (ObjectUtils.isEmpty(riskSource.getChildren())) {
            return 0;
        }
        int count = 0;
        if (status.equals("Qualified")) {
            count += riskSource.getQualified();
        } else if (status.equals("Unqualified")) {
            count += riskSource.getUnqualified();
        } else if (status.equals("Omission")) {
            count += riskSource.getOmission();
        } else if (status.equals("Unplan")) {
            count += riskSource.getUnplan();
        }
        for (RiskSourceTreeResponse action : riskSource.getChildren()) {
            if (ObjectUtils.isEmpty(action.getPosition3d())) {
                continue;
            }
            count = count + getPointChildrenCount(action, status);
            if (status.equals("Qualified")) {
                count += action.getQualified();
            } else if (status.equals("Unqualified")) {
                count += action.getUnqualified();
            } else if (status.equals("Omission")) {
                count += action.getOmission();
            } else if (status.equals("Unplan")) {
                count += action.getUnplan();
            }
        }

        return count;
    }


   // @Authorization(ingore = true)
    @ApiOperation(httpMethod = "GET", value = "统计级别为1的风险点下面设备统计", notes = "统计级别为1的风险点下面设备统计")
    @RequestMapping(value = "/equipStatistics/{type}", produces = "application/json;charset=UTF-8", method = RequestMethod.GET)
    public CommonResponse equipStatistics(@PathVariable(value = "type", required = true) String[] type) throws Exception {
        List<RiskSourceTreeResponse> riskSources = riskSourceService.findRiskSourceEquipStatistics(type);
        List<RiskSourceTreeResponse> treeRiskSources = getRiskSourcesEquipTree(riskSources);
        return CommonResponseUtil.success(riskSourceEquipStatistics(treeRiskSources, true, 0));
    }

    private static List<RiskSourceTreeResponse> getRiskSourcesEquipTree(List<RiskSourceTreeResponse> list) {
        List<RiskSourceTreeResponse> treeList = new ArrayList<RiskSourceTreeResponse>();
        for (RiskSourceTreeResponse tree : list) {
            if (tree.getParentId() != null && tree.getParentId() == 1) {
                treeList.add(tree);
            }
            for (RiskSourceTreeResponse treeNode : list) {
                if (treeNode.getParentId().longValue() == tree.getId()) {
                    if (tree.getChildren() == null) {
                        tree.setChildren(new ArrayList<RiskSourceTreeResponse>());
                    }
                    tree.getChildren().add(treeNode);
                }
            }
        }
        return treeList;
    }


    private Object riskSourceEquipStatistics(List<RiskSourceTreeResponse> list, Boolean isLevel, int level) {
        List<Map<String, Object>> treeList = new ArrayList<Map<String, Object>>();
        if (!ObjectUtils.isEmpty(list)) {
            Map<String, Object> map = new HashMap<>();

//        	List<RiskSourceTreeResponse> firstChildrens = list.get(0).getChildren();
            list.forEach(item -> {
//        		if (!ObjectUtils.isEmpty(item.getPosition3d())) {
                Map<String, Object> itemMap = (Map<String, Object>) map.get(item.getId());
                if (ObjectUtils.isEmpty(itemMap)) {
                    itemMap = new HashMap<>();
                    itemMap.put("id", item.getId());
                    itemMap.put("key", "key" + item.getId());
                    itemMap.put("name", item.getName());
                    if (isLevel) {
                        itemMap.put("level", level);
                    } else {
                        itemMap.put("level", item.getLevel());
                    }

                    Map<String, Object> position = new HashMap<>();

                    if (!ObjectUtils.isEmpty(item.getPosition3d())) {
                        String[] pos = item.getPosition3d().split(",");
                        position.put("x", pos[0]);
                        position.put("y", pos[1]);
                        position.put("z", pos[2]);
                    }
                    Map<String, Object> rotation = new HashMap<>();
                    rotation.put("x", 0);
                    rotation.put("y", 0);
                    rotation.put("z", 0);
                    Map<String, Object> scale = new HashMap<>();
                    scale.put("x", 1);
                    scale.put("y", 1);
                    scale.put("z", 1);

                    itemMap.put("position", position);
                    itemMap.put("scale", scale);
                    itemMap.put("rotation", rotation);
                }
                List<Map> itemCountList = new ArrayList<>();
                Map<String, Object> ItemCount = new HashMap<>();
                itemCountList.add(ItemCount);
                ItemCount.put("count", getRiskSourceEquipChildrenCount(item));
                itemMap.put("statisticsData", itemCountList);
                map.put(item.getId() + "", itemMap);
//        		}
            });
            for (String key : map.keySet()) {
                treeList.add((Map<String, Object>) map.get(key));
            }

        }

        return treeList;
    }


    private static int getRiskSourceEquipChildrenCount(RiskSourceTreeResponse item) {
        if (ObjectUtils.isEmpty(item.getChildren())) {
            return item.getCount();
        }
        int count = item.getCount();
        for (RiskSourceTreeResponse action : item.getChildren()) {
            count = count + getRiskSourceChildrenCount(action, null);
            count += action.getCount();
        }

        return count;
    }


    private static List<Map<String, Object>> riskSourceStatistics(List<RiskSourceTreeResponse> list) {
        List<Map<String, Object>> treeList = new ArrayList<Map<String, Object>>();
        if (!ObjectUtils.isEmpty(list)) {
            Map<String, Object> map = new HashMap<>();

            List<RiskSourceTreeResponse> firstChildrens = list.get(0).getChildren();
            firstChildrens.forEach(item -> {
//        		if (!ObjectUtils.isEmpty(item.getPosition3d())) {
                Map<String, Object> itemMap = (Map<String, Object>) map.get(item.getId());
                if (ObjectUtils.isEmpty(itemMap)) {
                    itemMap = new HashMap<>();
                    itemMap.put("id", item.getId());
                    itemMap.put("key", "key" + item.getId());
                    itemMap.put("name", item.getName());
                    itemMap.put("level", item.getLevel());
                    Map<String, Object> position = new HashMap<>();

                    if (!ObjectUtils.isEmpty(item.getPosition3d())) {
                        String[] pos = item.getPosition3d().split(",");
                        position.put("x", pos[0]);
                        position.put("y", pos[1]);
                        position.put("z", pos[2]);
                    }
                    Map<String, Object> rotation = new HashMap<>();
                    rotation.put("x", 0);
                    rotation.put("y", 0);
                    rotation.put("z", 0);
                    Map<String, Object> scale = new HashMap<>();
                    scale.put("x", 1);
                    scale.put("y", 1);
                    scale.put("z", 1);

                    itemMap.put("position", position);
                    itemMap.put("scale", scale);
                    itemMap.put("rotation", rotation);
                }
                List<Map> itemCountList = new ArrayList<>();
                Map<String, Object> ItemCount = new HashMap<>();
                ItemCount.put("name", "告警");
                ItemCount.put("count", getRiskSourceChildrenCount(item, "ANOMALY"));
                itemCountList.add(ItemCount);
                Map<String, Object> ItemCount1 = new HashMap<>();
                ItemCount1.put("name", "风险点");
                ItemCount1.put("count", getRiskSourceChildrenCount(item, null));
                itemCountList.add(ItemCount1);
                itemMap.put("statisticsData", itemCountList);
                map.put(item.getId() + "", itemMap);
//        		}
            });
            for (String key : map.keySet()) {
                treeList.add((Map<String, Object>) map.get(key));
            }

        }

        return treeList;
    }

    private static int getRiskSourceChildrenCount(RiskSourceTreeResponse riskSource, String status) {
        if (ObjectUtils.isEmpty(riskSource.getChildren())) {
            return 0;
        }
        int count = 0;
        if ("ANOMALY".equals(status)) {
            count += (riskSource.getQualified() == null ? 0 : riskSource.getQualified());
        } else {
            count += (riskSource.getUnplan() == null ? 0 : riskSource.getUnplan());
        }
        for (RiskSourceTreeResponse action : riskSource.getChildren()) {
            if (ObjectUtils.isEmpty(action.getPosition3d())) {
                continue;
            }
            count = count + getRiskSourceChildrenCount(action, status);
            if (status != null) {
                if (status.equals(action.getStatus())) {
                    count++;
                }
            } else {
                count++;
            }
        }

        return count;
    }

    private static List<RiskSourceTreeResponse> getRiskSourcesTree(List<RiskSourceTreeResponse> list) {
        List<RiskSourceTreeResponse> treeList = new ArrayList<RiskSourceTreeResponse>();
        for (RiskSourceTreeResponse tree : list) {
            if (tree.getParentId() != null && tree.getParentId() == 0) {
                treeList.add(tree);
            }
            for (RiskSourceTreeResponse treeNode : list) {
                if (treeNode.getParentId().longValue() == tree.getId()) {
                    if (tree.getChildren() == null) {
                        tree.setChildren(new ArrayList<>());
                    }
                    tree.getChildren().add(treeNode);
                }
            }
        }
        return treeList;
    }

    /**
     * 根据风险点查询关联巡检点
     */
    @ApiOperation(value = "根据风险点查询关联巡检点", notes = "根据风险点查询关联巡检点")
    @GetMapping(value = "/getBindPoints", produces = "application/json;charset=UTF-8")
    public CommonResponse listFmeaPointInputitem(@ApiParam(value = "fmeaId", required = true) @RequestParam Long fmeaId,
                                                 @ApiParam(value = "分页参数", required = true) @RequestParam Integer pageNumber,
                                                 @ApiParam(value = "分页参数", required = true) @RequestParam Integer pageSize) {
        try {
            Page<Map<String, Object>> list = riskSourceService.listFmeaPointInputitem(fmeaId, pageNumber, pageSize);
            return CommonResponseUtil.success(list);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return CommonResponseUtil.failure("查询巡检点信息失败");
        }
    }

    @ApiOperation(httpMethod = "GET", value = "查询指定风险点绑定关系", notes = "查询指定风险点绑定关系")
    @RequestMapping(value = "/{fmeaId}/fireequiment/relations", produces = "application/json;charset=UTF-8", method = RequestMethod.GET)
    public CommonResponse queryBoundRelation(@PathVariable Long fmeaId,
                                             @RequestParam int pageNumber,
                                             @RequestParam int pageSize) {
        return CommonResponseUtil.success(riskSourceService.listFeamEquipmentPoint(fmeaId, pageNumber, pageSize));
    }

    @ApiOperation(value = "绑定巡检点检查项", notes = "绑定巡检点检查项")
    @PostMapping(value = "/bindFmea/pointInputitem")
    public CommonResponse bindFmeaPointInputitem(@RequestBody FmeaBindParam pointInputitems) {
        return CommonResponseUtil.success(riskSourceService.bindPointInputitem(pointInputitems));
    }

    @ApiOperation(value = "绑定消防设备指标", notes = "绑定消防设备指标")
    @PostMapping(value = "/bingFmea/equimentPoint")
    public CommonResponse bindFmeaEquimentPoint(@RequestBody FmeaBindParam fmeaBindParam) {
        return CommonResponseUtil.success(riskSourceService.bindFireEquiment(fmeaBindParam));
    }

//    @ApiOperation(httpMethod = "DELETE", value = "移除消防设备绑定关系", notes = "移除消防设备绑定关系")
//    @RequestMapping(value = "/fireequiment/relation/{ids}", produces = "application/json;charset=UTF-8", method = RequestMethod.DELETE)
//    public CommonResponse removeFireEquiment(@PathVariable("ids") String ids) throws Exception {
//        String[] idArray = ids.split(",");
//        return CommonResponseUtil.success(this.riskSourceService.removeBoundRelation(idArray));
//    }

    @ApiOperation(httpMethod = "GET", value = "查询绑定关系设备", notes = "查询绑定关系包含已绑定和未绑定")
    @RequestMapping(value = "/fireequiment/relation/all", produces = "application/json;charset=UTF-8", method = RequestMethod.GET)
    public CommonResponse queryRelationWithNoBound(
            @RequestParam String equimentId,
            @RequestParam(value = "fname", required = false) String fname,
            @RequestParam int pageNumber,
            @RequestParam int pageSize) throws Exception {

        CommonPageable commonPageable = new CommonPageable(pageNumber, pageSize);
        fname = StringUtils.trimToNull(fname);
        return CommonResponseUtil.success(riskSourceService.queryEquimentRelation(commonPageable, equimentId, fname));
    }

    @ApiOperation(value = "查询设备指标", notes = "查询设备指标")
    @GetMapping(value = "/listEquipmentPointById")
    public CommonResponse listEquipmentPointById(@RequestParam Long fmeaId,
                                                 @RequestParam Long importantEquipId,
                                                 @RequestParam Long equimentId,
                                                 @RequestParam(required = false) String equipmentPointName) {
        return CommonResponseUtil.success(riskSourceService.listEquipmentPointById(fmeaId, importantEquipId, equimentId, equipmentPointName));
    }

   // @Authorization(ingore = true)
    @ApiOperation(httpMethod = "PUT", value = "上传消防设备数据", notes = "上传消防设备数据")
    @RequestMapping(value = "/data/fireqeuiment", produces = "application/json;charset=UTF-8", method = RequestMethod.PUT)
    public CommonResponse postFireEqumentData(@RequestBody FireEquimentDataRo deviceData) throws Exception {
        return CommonResponseUtil.success(riskSourceService.processFireEqumtData(deviceData));
    }

   // @Authorization(ingore = true)
    @ApiOperation(httpMethod = "POST", value = "上传消防设备数据", notes = "上传消防设备数据")
    @RequestMapping(value = "/data/fireqeuiment/soe", produces = "application/json;charset=UTF-8", method = RequestMethod.POST)
    public CommonResponse postFireEqumentData(@RequestBody AlarmParam alarm) throws Exception {
        log.debug("pointCode=soe=" + alarm.getPointCode() + " InformationAddress=soe=" + alarm.getInformationAddress());
        riskSourceService.processFireEqumtData(alarm);
        return CommonResponseUtil.success();
    }

   // @Authorization(ingore = true)
    @ApiOperation(httpMethod = "POST", value = "上传消防设备数据", notes = "上传消防设备数据")
    @RequestMapping(value = "/data/fireqeuiment/all", produces = "application/json;charset=UTF-8", method = RequestMethod.POST)
    public CommonResponse postFireEqumentData(@RequestBody List<AlarmParam> deviceDatas) throws Exception {
        riskSourceService.saveData(deviceDatas, "all");
        return CommonResponseUtil.success();
    }


    //@Authorization(ingore = true)
    @ApiOperation(httpMethod = "PUT", value = "上传巡检数据", notes = "上传巡检数据")
    @RequestMapping(value = "/data/patroldata", produces = "application/json;charset=UTF-8", method = RequestMethod.PUT)
    public CommonResponse postPatrolData(@RequestBody ProtalDataRo protalData) throws Exception {
        riskSourceService.processProtalData(getToken(),getProduct(),getAppKey(),protalData);
        return CommonResponseUtil.success();
    }

    //@Authorization(ingore = true)
    @ApiOperation(httpMethod = "PUT", value = "上传巡检任务数据", notes = "上传巡检任务数据")
    @RequestMapping(value = "/data/task", produces = "application/json;charset=UTF-8", method = RequestMethod.PUT)
    public CommonResponse postTaskData(@RequestBody ProtalDataRo taskData) throws Exception {

        return CommonResponseUtil.success(riskSourceService.processTaskData(taskData));
    }

//    @ApiOperation(httpMethod = "POST", value = "删除风险点巡检点检查项", notes = "删除风险点巡检点检查项")
//    @RequestMapping(value = "/removeByRSIdAndPId", produces = "application/json;charset=UTF-8", method = RequestMethod.POST)
//    @Authorization(ingore = true)
//    public CommonResponse removeByRSIdAndPId(@RequestBody List<HashMap<String, String>> list) throws Exception {
//        try {
//            riskSourceService.removeByRSIdAndPId(list);
//            return CommonResponseUtil.success();
//        } catch (Exception e) {
//            log.error(e.getMessage(), e);
//            return CommonResponseUtil.failure("删除失败");
//        }
//    }

    /**
     * 查询风险点明细
     *
     * @param id
     * @return
     * @throws Exception
     */
    @ApiOperation(value = "查询风险点明细", notes = "查询风险点明细")
    @GetMapping(value = "/detailById/{id}", produces = "application/json;charset=UTF-8")
    public CommonResponse queryRiskSourceDetailById(@PathVariable Long id) {
        RiskSourceTreeResponse det = riskSourceService.queryRiskSourceDetailById(id);
        return CommonResponseUtil.success(det);
    }


    @ApiOperation(value = "风险预警详情", notes = "风险预警详情")
    @GetMapping(value = "/warning/detail", produces = "application/json;charset=UTF-8")
    public CommonResponse earlyWarning(@RequestParam Long riskSourceId) {
        Map map = riskSourceService.earlyWarning(riskSourceId);
        return CommonResponseUtil.success(map);
    }

    /**
     * 获取厂区下所有区域的风险点的rpn值
     */
    @ApiOperation(httpMethod = "GET", value = "获取厂区下所有区域的风险点的rpn值", notes = "获取厂区下所有区域的风险点的rpn值")
    @RequestMapping(value = "/queryRiskAreaRpn", produces = "application/json;charset=UTF-8", method = RequestMethod.GET)
    public CommonResponse queryRiskAreaRpn() {

        return CommonResponseUtil.success(riskSourceService.queryRiskAreaRpn());
    }


    /**
     * @return
     */
    //@Authorization(ingore = true)
    @ApiOperation(httpMethod = "POST", value = "设置预案节点自动执行", notes = "设置预案节点自动执行")
    @RequestMapping(value = "/contingency/setup", produces = "application/json;charset=UTF-8", method = RequestMethod.POST)
    public CommonResponse queryRiskSourceSecondLevel(@RequestBody ContingencyDeviceStatus contingencyDeviceStatus) {
        riskSourceService.queryContingencyDeviceStatus(contingencyDeviceStatus);
        return CommonResponseUtil.success();
    }

    //@Authorization(ingore = true)
    @ApiOperation(httpMethod = "GET", value = "初始化預案水資源", notes = "初始化預案水資源")
    @RequestMapping(value = "/contingency/water", produces = "application/json;charset=UTF-8", method = RequestMethod.GET)
    public CommonResponse queryContingencyWater() {
        return CommonResponseUtil.success(riskSourceService.queryContingencyWater());
    }

    /**
     * 获取危险因素树二级节点
     *
     * @return
     */
    @ApiOperation(httpMethod = "GET", value = "获取危险因素树二级节点", notes = "获取危险因素树二级节点")
    @RequestMapping(value = "/riskSourceSecondLevel", produces = "application/json;charset=UTF-8", method = RequestMethod.GET)
    public CommonResponse queryRiskSourceSecondLevel() {
        return CommonResponseUtil.success(riskSourceService.queryRiskSourceSecondLevel());
    }

    /**
     * 获取巡检点FMEA
     *
     * @return
     */
    @ApiOperation(httpMethod = "GET", value = "获取危险因素树二级节点", notes = "获取危险因素树二级节点")
    @RequestMapping(value = "/queryFmea/point/{pointId}", produces = "application/json;charset=UTF-8", method = RequestMethod.GET)
    public CommonResponse queryFmeaByPointId(@PathVariable Long pointId) {
        return CommonResponseUtil.success(riskSourceService.queryFmeaByPointId(pointId));
    }
}
