package com.yeejoin.amos.fas.business.dao.mapper;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.yeejoin.amos.fas.business.bo.CheckErrorBo;
import com.yeejoin.amos.fas.business.bo.RiskPointRpnChangeBo;
import com.yeejoin.amos.fas.business.bo.SafetyExecuteBo;
import com.yeejoin.amos.fas.business.vo.View3dNodeVo;
import com.yeejoin.amos.fas.dao.entity.RiskSource;
import org.apache.ibatis.annotations.Param;

import com.yeejoin.amos.fas.core.common.response.RegionTreeResponse;

public interface View3dMapper extends BaseMapper{
	/**
	 * 按类型查询树
	 * @param type
	 * @param orgCode
	 * @return
	 */
	List<RegionTreeResponse> getPointTreeByType(@Param("type")String type,@Param("orgCode")String orgCode);
	
	/**
	 * 获取点详情
	 * @param type
	 * @param pointId
	 * @param orgCode
	 * @return
	 */
	HashMap<String, Object> getPointDetailByTypeAndId(@Param("type")String type, @Param("pointId")Long pointId,@Param("orgCode")String orgCode);

	/**
	 * 统计风险上升异常数量（风险点）-日期+机构
	 * @param param:{type，orgCode}
	 * @return Long
	 */
	Long countUpperRiskPoint(Map<String,Object> param);

	/**
	 * 统计巡检异常数量（不合格、漏检）-日期+机构
	 * @param param{}
	 * @return Long
	 */
	Long countCheckException(Map<String,Object> param);

	/**
	 * 今日安全指数详情
	 * @param params orgCode,date
	 * @return list
	 */
    List<RiskPointRpnChangeBo> getAllErrorRiskPoint(Map<String, Object> params);
    
    /**
     * 一周安全指数趋势查询
     * @param orgCode
     * @return
     */
    List<HashMap<String, Object>> getSafetyIndexWeek(@Param("orgCode")String orgCode);

    /**
     * 今日安全指数详情
     * @param params orgCode,date
     * @return list
     */
	List<CheckErrorBo> getAllErrorPatrolPoint(Map<String, Object> params);

	/**
	 * 今日巡检统计接口
	 * @param orgCode
	 * @return
	 */
	List<HashMap<String, Object>> getStatisticsCheck(String orgCode);
	
	/**
	 * 风险异常显示最新5条
	 * @param orgCode
	 * @return
	 */
	List<SafetyExecuteBo> getRiskErrorTop5(String orgCode);

	/**
	 * 巡检异常示最新5条
	 * @param orgCode
	 * @return
	 */
	List<SafetyExecuteBo> getCheckErrorTop5(String orgCode);

	/**
	 * 按照类型查询点
	 * @param params {orgCode,type}
	 * @return 列表
	 */
	List<HashMap<String, Object>> getPintsByType(Map<String, Object> params);
	
	/**
	 * 更新safetyIndexchangelog
	 */
	void safetyIndexRefresh();
	
	/**
	 * 重点模式设备
	 * @return
	 */
	List<View3dNodeVo> getImpEqu3dPoints(String orgCode);

	/**
	 * 异常点
	 * @param type
	 * @param orgCode
	 * @return
	 */
	List<View3dNodeVo> initViewErrorNode(String type, String orgCode);
}
