package com.yeejoin.amos.fas.business.jpush;

import cn.jpush.api.JPushClient;
import cn.jpush.api.push.model.Platform;
import cn.jpush.api.push.model.PushPayload;
import cn.jpush.api.push.model.audience.Audience;
import cn.jpush.api.push.model.notification.Notification;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.List;


@Service
public class AppMessagePushService {

    protected static final Logger log = LoggerFactory.getLogger(AppMessagePushService.class);

    @Value("${params.isPush}")
    private String isPush;

    private static final String APP_KEY = "1b3f7b961200f4b236811dfe";

    private static final String MASTER_SECRET = "8b650e645fb3a43c96be02b2";

    private static JPushClient jpushClient = new JPushClient(MASTER_SECRET, APP_KEY);

    public void sendMessage(List<PushMsgParam> responses) {
        try {
            if (responses != null && "true".equals(isPush)) {
                for (PushMsgParam response : responses) {
                    PushPayload payload = buildPushPayload(response);
                    jpushClient.sendPush(payload);
                }
            }
        } catch (Exception e) {
            log.error("极光推送异常", e);
        }
    }

    private PushPayload buildPushPayload(PushMsgParam response) {
        if (JPushTypeEnum.ALL.getCode().equals(response.getType())) {
            return PushPayload.newBuilder()
                    .setPlatform(Platform.android())
                    .setAudience(Audience.all())
                    .setNotification(Notification.android(response.getContent(), response.getSubject(), response.getExtras()))
                    .build();
        } else if (JPushTypeEnum.TAG.getCode().equals(response.getType())) {
            return PushPayload.newBuilder()
                    .setPlatform(Platform.android())
                    .setAudience(Audience.tag(response.getRecivers()))
                    .setNotification(Notification.android(response.getContent(), response.getSubject(), response.getExtras()))
                    .build();
        } else {
            return PushPayload.newBuilder()
                    .setPlatform(Platform.android())
                    .setAudience(Audience.alias(response.getRecivers()))
                    .setNotification(Notification.android(response.getContent(), response.getSubject(), response.getExtras()))
                    .build();
        }
    }

    public void sendMessage(PushMsgParam response) {
        try {
            if (null != response && "true".equals(isPush)) {
                PushPayload payload = PushPayload.newBuilder().setPlatform(Platform.android())
                        .setAudience(Audience.all())
                        .setNotification(Notification.android(response.getContent(), response.getSubject(), response.getExtras()))
                        .build();
                jpushClient.sendPush(payload);
            }
        } catch (Exception e) {
            log.error("极光推送异常", e);
        }
    }

}
