package com.yeejoin.amos.fas.business.service.impl;

import com.yeejoin.amos.fas.business.dao.mapper.FireEquipMapper;
import com.yeejoin.amos.fas.business.dao.mapper.ImpEquipMapper;
import com.yeejoin.amos.fas.business.dao.mapper.Node3dVoMapper;
import com.yeejoin.amos.fas.business.dao.repository.IFireEquipmentDao;
import com.yeejoin.amos.fas.business.dao.repository.IFireStationDao;
import com.yeejoin.amos.fas.business.dao.repository.IWaterResourceDao;
import com.yeejoin.amos.fas.business.param.CommonPageInfoParam;
import com.yeejoin.amos.fas.business.service.intfc.IFireEquipService;
import com.yeejoin.amos.fas.business.util.FireEquipmentType;
import com.yeejoin.amos.fas.core.common.request.CommonPageable;
import com.yeejoin.amos.fas.core.common.response.CommonPage;
import com.yeejoin.amos.fas.dao.entity.FireEquipment;
import com.yeejoin.amos.fas.dao.entity.FireStation;
import com.yeejoin.amos.fas.dao.entity.WaterResource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

@Service("fireEquipService")
public class FireEquipServiceImpl implements IFireEquipService {

    @Autowired
    FireEquipMapper fireEquipMapper;

    @Autowired
    IFireEquipmentDao iFireEquipmentDao;

    @Autowired
    ImpEquipMapper impEquipMapper;

    @Autowired
    IWaterResourceDao iWaterResourceDao;

    @Autowired
    IFireStationDao iFireStationDao;
    

	@Autowired
	Node3dVoMapper node3dVoMapper;


    public FireEquipment save(FireEquipment fireEquipment) {
    	Long id = fireEquipment.getId();
    	fireEquipment = iFireEquipmentDao.saveAndFlush(fireEquipment);
		if(id ==null || id == 0){
			node3dVoMapper.incrementalCreateFierEqumt(fireEquipment.getId());
		}else{
			node3dVoMapper.incrementalUpdateFierEqumt(id);
		}
		return fireEquipment;
    }


    public FireEquipment queryOne(Long id) {
    	Optional<FireEquipment> fireEquipment1=iFireEquipmentDao.findById(id);
    	if(fireEquipment1.isPresent()){
    		return fireEquipment1.get();
    	}
    	return null;
    }

    public String[] delete(String[] idArray) throws Exception {
        for (String id : idArray) {
            Optional<FireEquipment> fireEquipment1 = iFireEquipmentDao.findById(Long.parseLong(id));
            FireEquipment fireEquipment=null;
            if(fireEquipment1.isPresent()){
            	fireEquipment= fireEquipment1.get();
        	}
            
            if (fireEquipment != null) {
                this.iFireEquipmentDao.deleteById(Long.parseLong(id));
            	node3dVoMapper.incrementalDeleteFierEqumt(Long.parseLong(id));
            } else {
                throw new Exception("找不到指定的对象:" + id);
            }
        }

        return idArray;
    }


    @Override
    public Page<HashMap<String, Object>> queryFireEquip(CommonPageInfoParam param) {
        long total = fireEquipMapper.countPageData(param);
        List<HashMap<String, Object>> content = fireEquipMapper.getFireEquipPage(param);
        Page<HashMap<String, Object>> result = new PageImpl<HashMap<String, Object>>(content, param, total);
        return result;
    }

    @Override
    public Page<HashMap<String, Object>> queryFireEquipByProId(CommonPageInfoParam param) {
        long total = fireEquipMapper.countFireEquipByEquipIdPageData(param);
        List<HashMap<String, Object>> content = fireEquipMapper.getFFireEquipByEquipIdPage(param);
        Page<HashMap<String, Object>> result = new PageImpl<HashMap<String, Object>>(content, param, total);
        return result;
    }

    @Override
    public List<String> findFireEquipArea() {
        return iFireEquipmentDao.findFireEquipArea();
    }


    //查询 消防设备历史数据
    public Page queryForFireEquipmentHistory(String fireEquipmentName,
                                                  String equipmentName,
                                                  String startTime,
                                                  String endTime,
                                                                      CommonPageable commonPageable) {

        long total = fireEquipMapper.queryForFireEquipmentHistoryCount( fireEquipmentName,equipmentName,
                startTime,
                endTime);

        List<Map> content  =  fireEquipMapper.queryForFireEquipmentHistory(fireEquipmentName,
                equipmentName,
                startTime,
                endTime,
                commonPageable.getOffset(),
                commonPageable.getPageSize());
        Page result = new CommonPage(content,  commonPageable, total);
        return result;
    }


   public  Page queryForEquipmentList(String name, String code,String equipClassify,CommonPageable commonPageable) {
       long total = fireEquipMapper.queryForEquipmentPageCount( name, code,equipClassify);
       List<Map> content  =  this.fireEquipMapper.queryForEquipmentPage(name, code,equipClassify,commonPageable.getOffset(),commonPageable.getPageSize());
       Page result = new CommonPage(content,  commonPageable, total);
       return result;
    }


    /**
     * 查询设备信息明细
     * @param type
     * @param id
     * @return
     * @throws Exception
     */
    public Object queryForDetail(String type, Long id) throws Exception
    {

        Object returnEntity = null;

        FireEquipmentType fireEquipmentType = FireEquipmentType.valueOf(type);

        switch (fireEquipmentType)
        {
            case pool:
            case hydrant:
                Optional<WaterResource> waterResource = this.iWaterResourceDao.findById(id);
                if(waterResource.isPresent()){
                	returnEntity = waterResource.get();
            	}
                
                
                break;
            case fireFoamRoom:
            case fireChamber:
                Optional<FireStation> fireStation1 = iFireStationDao.findById(id);
                FireStation fireStation=null;
                if(fireStation1.isPresent()){
                	 fireStation=fireStation1.get();
            	}
                fireStation.setFireEquipmentInfo(this.fireEquipMapper.queryForGroupCount(id));
                returnEntity = fireStation;
                break;
            case extinguisher:
            case video:
            case monitorEquipment:
                Optional<FireEquipment> fireEquipment1 = this.iFireEquipmentDao.findById(id);
                FireEquipment fireEquipment=null;
                if(fireEquipment1.isPresent()){
                	fireEquipment=fireEquipment1.get();
            	}
                fireEquipment.setProtectObjNames(this.impEquipMapper.queryProtectObjNames(fireEquipment.getId()));
                returnEntity = fireEquipment;
                break;
            case fireDetection:
                Optional<FireEquipment> fireDetection1 = this.iFireEquipmentDao.findById(id);
                FireEquipment fireDetection=null;
                if(fireDetection1.isPresent()){
                	fireDetection=fireDetection1.get();
            	}
                fireDetection.setProtectObjNames(this.impEquipMapper.queryProtectObjNames(fireDetection.getId()));
                returnEntity = fireDetection;
                break;
            default:
                throw new Exception("类型有误.");

        }
        return returnEntity;
    }




}
