package com.yeejoin.amos.fas.business.service.impl;

import com.yeejoin.amos.fas.business.dao.mapper.Node3dVoMapper;
import com.yeejoin.amos.fas.business.service.intfc.Node3dVoService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

import java.util.concurrent.Callable;

@Service("node3dVoService")
public class Node3dVoServiceImpl implements Node3dVoService {


	@Autowired
	private Node3dVoMapper node3dVoMapper ;

	@Override
	public Integer incrementalCreate(String dataType) {
		Integer result = 0;
		switch (dataType)
		{
			case DATATYPE_FIREEQUMT:
				result = node3dVoMapper.incrementalCreateFierEqumt(null);
				break;
			case DATATYPE_IMPEQUMT:
				result = node3dVoMapper.incrementalCreateImpEqumt(null);
				break;
			case DATATYPE_RISKSOURCE:
				result = node3dVoMapper.incrementalCreateRiskSource(null);
				break;
			case DATATYPE_FIRECAR:
				result = node3dVoMapper.incrementalCreateFireCar(null);
				break;
			case DATATYPE_STATION:
				result = node3dVoMapper.incrementalCreateStation(null);
				break;
			case DATATYPE_WATER:
				result = node3dVoMapper.incrementalCreateWater(null);
				break;
		}
		return result;
	}

	@Override
	public Integer incrementalRemove(String dataType) {
		Integer result = 0;
		switch (dataType)
		{
			case DATATYPE_FIREEQUMT:
				result = node3dVoMapper.incrementalDeleteFierEqumt(null);
				break;
			case DATATYPE_IMPEQUMT:
				result = node3dVoMapper.incrementalDeleteImpEqumt(null);
				break;
			case DATATYPE_RISKSOURCE:
				result = node3dVoMapper.incrementalDeleteRiskSource(null);
				break;
			case DATATYPE_FIRECAR:
				result = node3dVoMapper.incrementalDeleteFireCar(null);
				break;
			case DATATYPE_STATION:
				result = node3dVoMapper.incrementalDeleteStation(null);
				break;
			case DATATYPE_WATER:
				result = node3dVoMapper.incrementalDeleteWater(null);
				break;
		}
		return result;
	}

	@Override
	public Integer incrementalUpdate(String dataType) {
		Integer result = 0;
		switch (dataType)
		{
			case DATATYPE_FIREEQUMT:
				result = node3dVoMapper.incrementalUpdateFierEqumt(null);
				break;
			case DATATYPE_IMPEQUMT:
				result = node3dVoMapper.incrementalUpdateImpEqumt(null);
				break;
			case DATATYPE_RISKSOURCE:
				result = node3dVoMapper.incrementalUpdateRiskSource(null, null);
				break;
			case DATATYPE_FIRECAR:
				result = node3dVoMapper.incrementalUpdateFireCar(null);
				break;
			case DATATYPE_STATION:
				result = node3dVoMapper.incrementalUpdateStation(null);
				break;
			case DATATYPE_WATER:
				result = node3dVoMapper.incrementalUpdateWater(null);
				break;
		}
		return result;
	}


	/**
	 *
	 * @param dataType
	 * @return
	 */
	@Override
	public Integer incrementalDataType(String dataType) {
		Integer result = 0;
		switch (dataType)
		{
			case DATATYPE_FIREEQUMT:
				result += node3dVoMapper.incrementalCreateFierEqumt(null)==null?0:node3dVoMapper.incrementalCreateFierEqumt(null);
				result += node3dVoMapper.incrementalUpdateFierEqumt(null)==null?0:node3dVoMapper.incrementalUpdateFierEqumt(null);
				result += node3dVoMapper.incrementalDeleteFierEqumt(null)==null?0:node3dVoMapper.incrementalDeleteFierEqumt(null);
				break;
			case DATATYPE_IMPEQUMT:
				result += node3dVoMapper.incrementalCreateImpEqumt(null)==null?0:node3dVoMapper.incrementalCreateImpEqumt(null);
				result += node3dVoMapper.incrementalUpdateImpEqumt(null)==null?0:node3dVoMapper.incrementalUpdateImpEqumt(null);
				result += node3dVoMapper.incrementalDeleteImpEqumt(null)==null?0:node3dVoMapper.incrementalDeleteImpEqumt(null);
				break;
			case DATATYPE_RISKSOURCE:
				result += node3dVoMapper.incrementalCreateRiskSource(null)==null?0:node3dVoMapper.incrementalCreateRiskSource(null);
				result += node3dVoMapper.incrementalUpdateRiskSource(null, null)==null?0:node3dVoMapper.incrementalUpdateRiskSource(null, null);
				result += node3dVoMapper.incrementalDeleteRiskSource(null)==null?0:node3dVoMapper.incrementalDeleteRiskSource(null);
				break;
			case DATATYPE_FIRECAR:
				result += node3dVoMapper.incrementalCreateFireCar(null)==null?0:node3dVoMapper.incrementalCreateFireCar(null);
				result += node3dVoMapper.incrementalUpdateFireCar(null)==null?0:node3dVoMapper.incrementalUpdateFireCar(null);
				result += node3dVoMapper.incrementalDeleteFireCar(null)==null?0:node3dVoMapper.incrementalDeleteFireCar(null);
				break;

			case DATATYPE_STATION:
				result += node3dVoMapper.incrementalCreateStation(null)==null?0:node3dVoMapper.incrementalCreateStation(null);
				result += node3dVoMapper.incrementalUpdateStation(null)==null?0:node3dVoMapper.incrementalUpdateStation(null);
				result += node3dVoMapper.incrementalDeleteStation(null)==null?0:node3dVoMapper.incrementalDeleteStation(null);
				break;
			case DATATYPE_WATER:
				result += node3dVoMapper.incrementalCreateWater(null)==null?0:node3dVoMapper.incrementalCreateWater(null);
				result += node3dVoMapper.incrementalUpdateWater(null)==null?0:node3dVoMapper.incrementalUpdateWater(null);
				result += node3dVoMapper.incrementalDeleteWater(null)==null?0:node3dVoMapper.incrementalDeleteWater(null);
				break;
		}
		return result;
	}

	@Override
	public Integer wholeIncremental() {
		Integer result = 0;

		//消防设备
		result += node3dVoMapper.incrementalCreateFierEqumt(null)==null?0:node3dVoMapper.incrementalCreateFierEqumt(null);
		result += node3dVoMapper.incrementalUpdateFierEqumt(null)==null?0:node3dVoMapper.incrementalUpdateFierEqumt(null);
		result += node3dVoMapper.incrementalDeleteFierEqumt(null)==null?0:node3dVoMapper.incrementalDeleteFierEqumt(null);

		//重点设备
		result += node3dVoMapper.incrementalCreateImpEqumt(null)==null?0:node3dVoMapper.incrementalCreateImpEqumt(null);
		result += node3dVoMapper.incrementalUpdateImpEqumt(null)==null?0:node3dVoMapper.incrementalUpdateImpEqumt(null);
		result += node3dVoMapper.incrementalDeleteImpEqumt(null)==null?0:node3dVoMapper.incrementalDeleteImpEqumt(null);

		//风险点
		result += node3dVoMapper.incrementalCreateRiskSource(null)==null?0:node3dVoMapper.incrementalCreateRiskSource(null);
		result += node3dVoMapper.incrementalUpdateRiskSource(null, null)==null?0:node3dVoMapper.incrementalUpdateRiskSource(null, null);
		result += node3dVoMapper.incrementalDeleteRiskSource(null)==null?0:node3dVoMapper.incrementalDeleteRiskSource(null);

		//消防车
		result += node3dVoMapper.incrementalCreateFireCar(null)==null?0:node3dVoMapper.incrementalCreateFireCar(null);
		result += node3dVoMapper.incrementalUpdateFireCar(null)==null?0:node3dVoMapper.incrementalUpdateFireCar(null);
		result += node3dVoMapper.incrementalDeleteFireCar(null)==null?0:node3dVoMapper.incrementalDeleteFireCar(null);


		//消防室和泡沫间
		result += node3dVoMapper.incrementalCreateStation(null)==null?0:node3dVoMapper.incrementalCreateStation(null);
		result += node3dVoMapper.incrementalUpdateStation(null)==null?0:node3dVoMapper.incrementalUpdateStation(null);
		result += node3dVoMapper.incrementalDeleteStation(null)==null?0:node3dVoMapper.incrementalDeleteStation(null);


		//水资源
		result += node3dVoMapper.incrementalCreateWater(null)==null?0:node3dVoMapper.incrementalCreateWater(null);
		result += node3dVoMapper.incrementalUpdateWater(null)==null?0:node3dVoMapper.incrementalUpdateWater(null);
		result += node3dVoMapper.incrementalDeleteWater(null)==null?0:node3dVoMapper.incrementalDeleteWater(null);


		return result;
	}

	@Override
	public Integer updateByRiskSourceId(Long riskSourceId, Integer frequency) {
		Integer result = 0;
		result = node3dVoMapper.incrementalUpdateRiskSource(riskSourceId, frequency);
		return result;
	}

	@Async
	@Override
	public  Integer syncData(Callable<Integer> callable ) throws Exception
	{
			return callable.call();
	}


}
