package com.yeejoin.amos.fas.business.service.intfc;

import com.yeejoin.amos.fas.business.vo.TreeSubjectVo;
import com.yeejoin.amos.fas.core.util.CommonResponse;
import com.yeejoin.amos.fas.dao.entity.TextPlan;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

public interface IPlanVisual3dService {

    /**
     * 获取预案树
     *
     * @return
     */
    List<TreeSubjectVo> getPlanTree();

    /**
     * 上传文字预案
     *  @param appId 预案ID
     * @param pathNameMap 文字预案文件路径:文件名称map
     */
    void uploadTextPlan(String appId, Map<String, String> pathNameMap);

    /**
     * 根据ID获取文本预案
     *
     * @param id
     * @return
     */
    TextPlan getTextPlanInfoById(Long id);

    CommonResponse getResourceListByType(String type);

    List<Map<String,Object>> getResourceById(String type,Long id);
}
