package com.yeejoin.amos.fas.business.service.intfc;


import com.yeejoin.amos.fas.business.bo.BindPointBo;
import com.yeejoin.amos.fas.business.bo.SafetyExecuteBo;
import com.yeejoin.amos.fas.business.vo.ExceptionRegionVo;
import com.yeejoin.amos.fas.business.vo.SafetyIndexDetailVo;
import com.yeejoin.amos.fas.business.vo.TodaySafetyIndexVo;
import com.yeejoin.amos.fas.business.vo.View3dNodeVo;
import com.yeejoin.amos.fas.core.common.response.RegionTreeResponse;
import com.yeejoin.amos.fas.core.util.CommonResponse;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author DELL
 */
public interface IView3dService {

    /**
     * 区域绑定保存
     * @param pointBoList 数组
     * @return 空
     */
    CommonResponse setPoint3dPosition(List<BindPointBo> pointBoList);

    /**
     * 点类型查询
     * @return list
     */
	List<Map<String, String>> getPointType();

    /**
     * 按照分类查询点树
     * @param type 树类型字典值
     * @param orgCode 登陆机构
     * @return list
     */
	List<RegionTreeResponse> getPointTreeByType(String type,String orgCode);

	/**
	 * 获取点详情
	 * @param type	树类型
	 * @param pointId 点id
	 * @param orgCode 登录机构
	 * @return
	 */
	HashMap<String, Object> getPointDetailByTypeAndId(String type, Long pointId,String orgCode);

    /**
     * 今日安全指数
     * @param orgCode 登陆机构
     * @param date 日期
     * @return TodaySafetyIndexVo
     */
    TodaySafetyIndexVo getSafetyIndexInfoByDate(String orgCode, String date);

    /**
     * 今日安全指数详情
     * @param type 详情类型
     * @return list
     */
    List<SafetyIndexDetailVo> getSafetyIndexDetail(String type,String orgCode);

    /**
     * 一周安全指数趋势查询
     * @param orgCode
     * @return
     */
	List<HashMap<String, Object>> getSafetyIndexWeek(String orgCode);

	/**
	 * 查询上线日期时间
	 * @return  eg:10年3月2天
	 */
	/**
	 * 查询上线日期时间
	 * @param orgCode :登录机构
	 * @return eg:10年3月2天
	 */
	Map<String, Object> getSystemOnlineDate(String orgCode);


	List<ExceptionRegionVo> getExceptionRegion(String orgCode);
	
	/**
	 * 今日巡检统计接口
	 * @param orgCode
	 * @return
	 */
	List<Map<String, Object>> getStatisticsCheck(String orgCode);

	/**
	 * 最新五条异常
	 * @param type
	 * @param orgCode
	 * @return
	 */
	List<SafetyExecuteBo> getSafetyExecuteListTop5(String type, String orgCode);

	/**
	 * 今日值班统计
	 * @return
	 */
	CommonResponse getStatisticsDuty(String appKey, String product, String orgCode);

	/**
	 * 设备状态消息最新5条
	 * @param orgCode
	 * @return
	 */
	Object getEquipStatusList(String orgCode);
	
	/**
	 * 左侧菜单(异常点)
	 * @param type
	 * @param orgCode
	 * @return
	 */
	List<View3dNodeVo> initViewErrorNode(String type, String orgCode);
	/**
	 * 查询类型的点
	 * @param orgCode 机构
	 * @param model 模式类型
	 * @return list
	 */
	CommonResponse get3dPointsByModel(String orgCode,String model);

	/**
	 * 刷新安全指数
	 */
	void safetyIndexRefresh();
}
