package com.yeejoin.amos.fas.business.dao.repository;

import java.util.Optional;

import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;

import com.yeejoin.amos.fas.dao.entity.FireEquipmentPoint;

@Repository("iFireEquipmentPointDao")
public interface IFireEquipmentPointDao extends BaseDao<FireEquipmentPoint, Long> {

	Optional<FireEquipmentPoint> findById(Long id);

	FireEquipmentPoint findOneByCode(String pointCode);
	
	int countByCode(String code);

	@Query(value = "SELECT count(1) FROM `f_fmea_equipment_point` WHERE equipment_point_id in ?1", nativeQuery = true)
	int countImpEquipment(String[] idArray);

	@Query(value = "select group_CONCAT(r.name) from f_fmea_equipment_point ep " + 
			"left join f_fmea f on f.id = ep.fmea_id " + 
			"left join f_risk_source r on r.id = f.risk_source_id " + 
			" WHERE ep.equipment_point_id in ?1 ", nativeQuery = true)
	String findBindRiskSourceStrByPointIds(String[] idArray);

}
