package com.yeejoin.amos.fas.business.feign;

import java.util.List;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import com.yeejoin.amos.fas.business.jpush.PushMsgParam;
import com.yeejoin.amos.fas.core.util.CommonResponse;
import com.yeejoin.amos.fas.core.util.CommonResponseUtil;
@Service("pushFeignServer")
public class PushFeignServer {
	     private final RestTemplate restTemplate;

	    public PushFeignServer() {
	        this.restTemplate = new RestTemplate();
	    }
	
	    @Value("${Push.fegin.name}")
	    private String RPushFeginName;
	    private static String sendMessage = "/api/user/sendMessage";
	    
	    public  String geturls(String url){
	    	return "http://"+RPushFeginName+url;
	    }
	    public  HttpHeaders getHeader(String toke,String product,String appKey){
	    	HttpHeaders headers = new HttpHeaders();
		    headers.setContentType(MediaType.APPLICATION_JSON);
		    headers.set("Content-Type", "application/json");  
		    headers.set("token", toke);
		    headers.set("product",product);
		    headers.set("appKey", appKey);
		    return headers;
	    } 
	    
	    public CommonResponse sendMessage( String toke,String product,String appKey, List<PushMsgParam> pushMsgParam){
			 try {
				    HttpEntity httpEntity = new HttpEntity<>(pushMsgParam, getHeader( toke, product, appKey));
				    CommonResponse commonResponse1 =  restTemplate.postForObject(geturls(sendMessage),httpEntity, CommonResponse.class);
					return commonResponse1;
					} catch (Exception e) {
					e.printStackTrace();	 
					 return CommonResponseUtil.failure("发送失败");	
					 
					}
		}
}
