package com.yeejoin.amos.fas.business.service.impl;

import com.yeejoin.amos.fas.business.constants.FasConstant;
import com.yeejoin.amos.fas.business.dao.mapper.FireStationEquipmentMapper;
import com.yeejoin.amos.fas.business.dao.mapper.FireStationMapper;
import com.yeejoin.amos.fas.business.dao.repository.IEquipmentFireEquipmentDao;
import com.yeejoin.amos.fas.business.dao.repository.IFireEquipmentDao;
import com.yeejoin.amos.fas.business.dao.repository.IFireStationDao;
import com.yeejoin.amos.fas.business.dao.repository.IFireStationEquipmentDao;
import com.yeejoin.amos.fas.business.service.intfc.IFireStationService;
import com.yeejoin.amos.fas.core.common.request.CommonPageable;
import com.yeejoin.amos.fas.dao.entity.FireEquipment;
import com.yeejoin.amos.fas.dao.entity.FireStation;
import com.yeejoin.amos.fas.dao.entity.FireStationFireEquipment;
import com.yeejoin.amos.fas.exception.YeeException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.web.multipart.MultipartFile;

import java.io.File;
import java.io.IOException;
import java.util.*;

@Service("fireStationService")
public class FireStationServiceImpl implements IFireStationService {

	@Autowired
	IFireStationDao iFireStationDao;

	@Autowired
	FireStationMapper fireStationMapper;

	@Autowired
	FireStationEquipmentMapper fireStationEquipmentMapper;

	@Autowired
	IFireStationEquipmentDao iFireStationEquipmentDao;

	@Autowired
	IFireEquipmentDao iFireEquipmentDao;
	
	@Value("${windows.img.path}")
	private String winImgPath;

	@Value("${linux.img.path}")
	private String linuxImgPath;

	public FireStation save(FireStation fireStation) {
		Long id = fireStation.getId();
		iFireStationDao.saveAndFlush(fireStation);
		return fireStation;
	}

	public List<FireStationFireEquipment> saveStationFireEquipment(
			List<FireStationFireEquipment> fireStationFireEquipments) throws Exception {

		for (FireStationFireEquipment fireStationFireEquipment : fireStationFireEquipments) {
			Optional<FireStation> fireStation1 = iFireStationDao.findById(fireStationFireEquipment.getFireStationId());
			Optional<FireEquipment> fireEquipment1 = iFireEquipmentDao.findById(fireStationFireEquipment.getFireEquipmentId());
			FireStation fireStation=null;
			FireEquipment fireEquipment=null;
			if(fireStation1.isPresent()){
				 fireStation=fireStation1.get();
			}
			if(fireEquipment1.isPresent()){
				fireEquipment=fireEquipment1.get();
			}
			
			if (fireStation == null)
				throw new Exception("找不到指定的消防站");
			if (fireEquipment == null)
				throw new Exception("消防设备不存在");
			
//			if (!CollectionUtils.isEmpty(map))
//				throw new Exception("绑定关系已经存在.");
			
			Map map = fireStationEquipmentMapper.queryRelation(fireStationFireEquipment.getFireStationId(),
					fireStationFireEquipment.getFireEquipmentId());
			if (!CollectionUtils.isEmpty(map)) {
				if(fireEquipment.getEquipClassify() == 1) {//耗材类
					
					Long stationEquiId = (Long) map.get("id");
					Double number = (Double) map.get("number");//当前数量
					Double number2 = fireStationFireEquipment.getNumber();//添加的数量
					Double number3 = (double)fireEquipment.getNumber();//库存
					Double diff = number3 - number2;
					if(diff < 0){
						throw new Exception("添加数量超过现有数量！.");
					}else {
						Double curNumber = number + number2;
						fireStationEquipmentMapper.updateNumberById(stationEquiId,curNumber);
						fireEquipment.setNumber(diff.intValue());
						iFireEquipmentDao.saveAndFlush(fireEquipment);
					}
				}
			}else {
				fireStationFireEquipment = iFireStationEquipmentDao.save(fireStationFireEquipment);
			}
			
			

		}
		return fireStationFireEquipments;
	}

	public void deleteStationFireEquipment(List<FireStationFireEquipment> fireStationFireEquipments) throws Exception {

		for (FireStationFireEquipment fireStationFireEquipment : fireStationFireEquipments) {
			Map map = fireStationEquipmentMapper.queryRelation(fireStationFireEquipment.getFireStationId(),
					fireStationFireEquipment.getFireEquipmentId());
			if (!CollectionUtils.isEmpty(map)) {
				Long id = Long.parseLong(String.valueOf(map.get("id")));
				this.iFireStationEquipmentDao.deleteById(id);

			} else {
				throw new Exception("指定的数据不存在.");
			}
		}
	}

	public Map queryOne(Long id) {
		return fireStationMapper.queryOne(id);
	}

	public Page queryForFireEquemtPage(Long fireStationId, CommonPageable pageable) {
		Long total = fireStationMapper.queryCountForFireEqumntPage(fireStationId);
		List<Map> content = fireStationMapper.queryForFireEqumntPage(fireStationId, pageable.getOffset(),
				pageable.getPageSize());
		Page result = new PageImpl(content, pageable, total);
		return result;
	}

	@Transactional
	public String[] delete(String[] idArray) throws Exception {
		for (String id : idArray) {
			Optional<FireStation> fireStation1 = iFireStationDao.findById(Long.parseLong(id));
			FireStation fireStation=null;
			if(fireStation1.isPresent()){
				fireStation=fireStation1.get();
			}
			iFireStationEquipmentDao.deleteByStationId(Long.valueOf(id));
			if (fireStation != null) {
				this.iFireStationDao.deleteById(Long.parseLong(id));
			} else {
				throw new Exception("找不到指定的监测点:" + id);
			}
		}

		return idArray;
	}

	public Page queryForPage(String username, String code, String type, CommonPageable pageable) {
		Long total = fireStationMapper.queryCountForPage(username, code, type);
		List<Map> content = fireStationMapper.queryForPage(username, code, type, pageable.getOffset(),
				pageable.getPageSize());
		Page result = new PageImpl(content, pageable, total);
		return result;
	}

	public List<Map> queryForList(String username, String code, String type) {
		List<Map> content = fireStationMapper.queryForList(username, code, type);

		return content;
	}

	@Override
	public FireStation saveAndUpd(FireStation fireStation, MultipartFile[] files) {
		fireStation.setCreateDate(new Date());
		fireStation = save(fireStation);
		if (files != null && files.length > 0) {
			for (int i = 0; i < files.length; i++) {
				String picture =  fireStation.getPicture();
				MultipartFile file = files[i];
				if (file.isEmpty()) {
					continue;
				}
				String path = FasConstant.UPLOAD_ROOT_PATH + File.separator + FasConstant.UPLOAD_FIRESTATION_PATH+
						File.separator +fireStation.getName();
						
				String filePath = getRootPath() + path;
				String fileName = File.separator + file.getOriginalFilename();
				try {
					File dest = new File(filePath + File.separator + fileName);
					if (!dest.exists()) {
						if (dest.getParentFile() != null && !dest.getParentFile().exists()) {
							dest.getParentFile().mkdirs();
						}
						dest.createNewFile();
					}
					file.transferTo(dest);
				} catch (IOException e) {
					throw new YeeException("上传图片失败");
				}
				String photoFile = path + fileName;
				if ( picture != null && picture != "") {
					picture += "," + photoFile;
				} else {
					picture = photoFile;
				}
				fireStation.setPicture(picture);
			}
			fireStation = save(fireStation);

		} 

		return fireStation;
	}

	private String getRootPath() {
		String localPath = "";
		if ("\\".equals(File.separator)) {
			localPath += winImgPath;
		} else if ("/".equals(File.separator)) {
			localPath += linuxImgPath;
		}
		return localPath.trim();
	}

	@Override
	public Map queryForEuqimentListById(Long id) {
		Map<String,Object> result = new HashMap<String, Object>();
		result.put("fireStation", fireStationMapper.queryOne(id));
		result.put("EquipmentList", fireStationMapper.queryEquipCountById(id));
		return result;
	}

	@Override
	public Boolean isExistByCode(String code) {
		Optional<FireStation> optional = iFireStationDao.findByCode(code);
		return optional.isPresent();
	}

}
