package com.yeejoin.amos.fas.config;

import javax.servlet.http.HttpServletRequest;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ResponseBody;

import com.yeejoin.amos.fas.core.util.CommonResponse;
import com.yeejoin.amos.fas.core.util.CommonResponseUtil;
import com.yeejoin.amos.fas.exception.PermissionException;
import com.yeejoin.amos.fas.exception.YeeException;


@ControllerAdvice
public class ExceptionHandler {
	
	private static final Logger logger = LoggerFactory.getLogger(ExceptionHandler.class);
	
	@org.springframework.web.bind.annotation.ExceptionHandler(PermissionException.class)
    @ResponseBody
    public CommonResponse handlePermissionException(HttpServletRequest request, PermissionException ex) {
        return CommonResponseUtil.failure(ex.getMessage());
    }
	
	@org.springframework.web.bind.annotation.ExceptionHandler(YeeException.class)
    @ResponseBody
    public CommonResponse handleYeeException(HttpServletRequest request, YeeException ex) {
        return CommonResponseUtil.failure(ex.getMessage());
    }
	
    @org.springframework.web.bind.annotation.ExceptionHandler(Exception.class)
    @ResponseBody
    public CommonResponse handleException(HttpServletRequest request, Exception ex) {
    	return CommonResponseUtil.failure(ex.getMessage());
    }
}
