package com.yeejoin.amos.fas.business.controller;

import com.yeejoin.amos.fas.business.service.intfc.IPlanClassifyTreeService;
import com.yeejoin.amos.fas.business.vo.PlanClassifyTreeVo;
import com.yeejoin.amos.fas.business.vo.ReginParams;
import com.yeejoin.amos.fas.core.util.CommonResponseUtil2;
import com.yeejoin.amos.fas.core.util.ResponseModel;
import com.yeejoin.amos.fas.dao.entity.EmergencyRelationTree;
import com.yeejoin.amos.fas.dao.entity.PlanClassifyTree;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;

@RestController
@RequestMapping("/api/planClassifyTree")
@Api("预案分类树api")
public class PlanClassifyTreeController extends BaseController {

	@Autowired
	private IPlanClassifyTreeService planClassifyTreeService;

	@ApiOperation(value = "创建分类")
	@RequestMapping(value = "/save", method = RequestMethod.POST)
	public ResponseModel create(@RequestBody PlanClassifyTree model) {
		AgencyUserModel user = getUserInfo();
		ReginParams reginParams = getSelectedOrgInfo();
		String compCode = getOrgCode(reginParams);
		model.setOrgCode(compCode);
		model.setCreator(user.getUserId());
		model.setPlanType(UUID.randomUUID().toString());
		return CommonResponseUtil2.success(planClassifyTreeService.create(model));
	}

	@ApiOperation(value = "修改分类")
	@RequestMapping(value = "/update", method = RequestMethod.PUT)
	public ResponseModel update(@RequestBody PlanClassifyTree model) {
		AgencyUserModel user = getUserInfo();
		ReginParams reginParams = getSelectedOrgInfo();
		String compCode = getOrgCode(reginParams);
		model.setOrgCode(compCode);
		model.setCreator(user.getUserId());
		return CommonResponseUtil2.success(planClassifyTreeService.update(model));
	}

	@ApiOperation(value = "删除分类")
	@RequestMapping(value = "/{ids}", method = RequestMethod.DELETE)
	public ResponseModel delete(@PathVariable("ids") String ids) {
		return CommonResponseUtil2.success(planClassifyTreeService.delete(ids));
	}

	@ApiOperation(value = "查询分类树")
    @RequestMapping(value = "/tree", method = RequestMethod.GET)
	public ResponseModel getTree() {
		Collection<PlanClassifyTreeVo>  list = null;
		try {
			list = planClassifyTreeService.getTree();
		}catch (Exception e){
			e.printStackTrace();
			System.out.println(e.getStackTrace().toString());
		}
		return CommonResponseUtil2.success(list);
	}

	@ApiOperation(value = "查询分类树 - 新页面使用")
	@RequestMapping(value = "/treeNew", method = RequestMethod.GET)
	public ResponseModel getTreeNew() {
		Collection<PlanClassifyTreeVo>  list = null;
		try {
			list = planClassifyTreeService.getTree();
		}catch (Exception e){
			e.printStackTrace();
			System.out.println(e.getStackTrace().toString());
		}
		//增加根节点
		PlanClassifyTreeVo tree = new PlanClassifyTreeVo();
		tree.setId(0);
		tree.setClassifyName("全部");
		tree.setPlanType("0");
		tree.setChildren(list);
		List<PlanClassifyTreeVo> root = new ArrayList<>();
		root.add(tree);
		return CommonResponseUtil2.success(root);
	}

	@ApiOperation(value = "查询分类信息 - 新页面使用")
	@RequestMapping(value = "/getPlanClassifyInfo", method = RequestMethod.GET)
	public ResponseModel getPlanClassifyInfo() {
		return CommonResponseUtil2.success(planClassifyTreeService.findAllInfo());
	}
}
