package com.yeejoin.amos.fas.business.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.yeejoin.amos.fas.business.dao.mapper.EmergencyTaskRoleMapper;
import com.yeejoin.amos.fas.business.service.intfc.IPlanStepService;
import com.yeejoin.amos.fas.business.vo.PlanStepJsonVO;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.stream.Collectors;

@Service
public class PlanStepServiceImpl implements IPlanStepService {

    @Autowired
    private RedisTemplate redisTemplate;

    @Autowired
    private EmergencyTaskRoleMapper emergencyTaskRoleMapper;

    @Override
    public String getPlanStepRoleCodeByButtonCode(String buttonCode) {
        if (StringUtils.isNotBlank(buttonCode)) {
            List<PlanStepJsonVO> result = getPlanStepJsonVOS();
            List<PlanStepJsonVO> collect = result.stream().filter(x -> buttonCode.equalsIgnoreCase(x.getButtonCode())).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(collect)) {
                return collect.get(0).getRoleCode();
            }
        }
        return null;
    }

    @Override
    public int getPlanStepIndexByStepCode(String stepCode) {
        if (StringUtils.isNotBlank(stepCode)) {
            List<PlanStepJsonVO> result = getPlanStepJsonVOS();
            List<PlanStepJsonVO> collect = result.stream().filter(x -> stepCode.equalsIgnoreCase(x.getStepCode())).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(collect)) {
                return collect.get(0).getIndex();
            }
        }
        return -1;
    }

    @Override
    public List<PlanStepJsonVO> getPlanStepJsonVOS() {
        String planStepString = getPlanStep();
        List<PlanStepJsonVO> result = JSONObject.parseArray(planStepString, PlanStepJsonVO.class);
        return result;
    }

    @Override
    public String getPlanStep() {
        String planType = "";
        if (redisTemplate.hasKey("planType")) {
            planType = redisTemplate.boundValueOps("planType").get(0, -1);
        }
        String json = emergencyTaskRoleMapper.getPlanStepInfoByType(planType);
        return json;
    }

    @Override
    public List<PlanStepJsonVO> getPlanStepByParam(String planType) {
        String json = emergencyTaskRoleMapper.getPlanStepInfoByType(planType);
        List<PlanStepJsonVO> result = JSONObject.parseArray(json, PlanStepJsonVO.class);
        return result;
    }

    @Override
    public void initPlanStep() {
        redisTemplate.delete("planStep");
        redisTemplate.opsForValue().set("planStep", getPlanStep());
        redisTemplate.delete("isMock");
    }

    @Override
    public void initPlanTask() {
        redisTemplate.delete("planTask");
//        redisTemplate.opsForValue().set("planTask", "");
    }
}
