package com.yeejoin.amos.fas.business.service.intfc;


import com.yeejoin.amos.fas.business.vo.EmergencyTaskContentVo;
import com.yeejoin.amos.fas.core.common.request.CommonPageable;
import com.yeejoin.amos.fas.dao.entity.EmergencyRelation;
import com.yeejoin.amos.fas.dao.entity.EmergencyRelationTree;
import com.yeejoin.amos.fas.dao.entity.EmergencyTaskContent;
import org.springframework.data.domain.Page;

import java.util.List;

public interface IEmergencyTaskService  {

   Page<EmergencyTaskContent> list(Long obligationId, String planType, CommonPageable pageable);

   List<EmergencyRelationTree> treeList();

   void deleteTreeNode(Long obligationId ,Long personId);

   void save(EmergencyRelation emergencyRelation);

   void saveTaskConfig(EmergencyTaskContent emergencyTaskContent);

   String getRolesByUserId(String userId);

   List<Long> getPersonIds(Long obligationId);

   String getRolesNameByUserId(String userId);

   void saveTask(String stepCode, String batchNo);

   List<EmergencyTaskContentVo> getMustTaskList(String stepCode, String planType);
}
