package com.yeejoin.amos.fas.dao.entity;

import java.math.BigDecimal;
import java.util.Date;

import javax.persistence.*;


/**
 * The persistent class for the fire_equipment database table.
 * 
 */
@Entity
@Table(name="f_fire_equipment")
@NamedQuery(name="FireEquipment.findAll", query="SELECT f FROM FireEquipment f")
public class FireEquipment extends BasicEntity  {
	private static final long serialVersionUID = 1L;

	private String brand;

	private String code;
	
	/**
	 * 3维坐标
	 */
	private String position3d;
	
	/**
	 * 3维楼层
	 */
	private String floor3d;

	/**
	 * 是否室内 0-否 1-是
	 */
	@Column(name="is_indoor")
	private Boolean isIndoor;

	@Column(name="create_by")
	private String createBy;

	@Temporal(TemporalType.DATE)
	@Column(name="effective_date")
	private Date effectiveDate;

	@Column(name="maintenance_cycle")
	private int maintenanceCycle;
	
	/**
	 * 装备分类：0-设备类；1-耗材类
	 */
	@Column(name="equip_classify")
	private int equipClassify;

	private String manufacturer;

	private String model;

	private String name;

	private int number;

	@Column(name="org_code")
	private String orgCode;

	@Column(name="production_area")
	private String productionArea;

	@Temporal(TemporalType.DATE)
	@Column(name="production_date")
	private Date productionDate;

	private String remark;

	private String room;
	
	/**
	 * 装备编码
	 */
	@Column(name="equip_code")
	private String equipCode;
	
	/**
	 * 装备类型
	 */
	@Column(name="equip_type")
	private String equipType;
	
	/**
	 * 监测设备状态
	 */
	@Column(name="equip_status")
	private Integer equipStatus;


	private String unit;


	private String protectObjNames;
	
	/**
	 * 重量
	 */
	private BigDecimal weight;
	
	/**
	 * 动作状态
	 */
	@Column(name="action_state")
	private String actionState;
	
	/**
	 * 喷发状态
	 */
	@Column(name="eruption_state")
	private String eruptionState;
	
	/**
	 * 所属风险区域id
	 */
	@Column(name="risk_source_id")
	private Long riskSourceId;

	/**
	 * ue4位置
	 */
	@Lob
	private String ue4Location;

	/**
	 * ue4旋转
	 */
	@Lob
	private String ue4Rotation;

	public Long getRiskSourceId() {
		return riskSourceId;
	}

	public void setRiskSourceId(Long riskSourceId) {
		this.riskSourceId = riskSourceId;
	}

	public String getActionState() {
		return actionState;
	}

	public void setActionState(String actionState) {
		this.actionState = actionState;
	}

	public String getEruptionState() {
		return eruptionState;
	}

	public void setEruptionState(String eruptionState) {
		this.eruptionState = eruptionState;
	}

	@Transient
	public String getProtectObjNames() {
		return protectObjNames;
	}

	public void setProtectObjNames(String protectObjNames) {
		this.protectObjNames = protectObjNames;
	}

	public Integer getEquipStatus() {
		return equipStatus;
	}

	public void setEquipStatus(Integer equipStatus) {
		this.equipStatus = equipStatus;
	}
	
	public FireEquipment() {
	}

	public String getBrand() {
		return this.brand;
	}

	public void setBrand(String brand) {
		this.brand = brand;
	}

	public String getCode() {
		return this.code;
	}

	public void setCode(String code) {
		this.code = code;
	}

	public String getCreateBy() {
		return this.createBy;
	}

	public void setCreateBy(String createBy) {
		this.createBy = createBy;
	}

	public Date getEffectiveDate() {
		return this.effectiveDate;
	}

	public void setEffectiveDate(Date effectiveDate) {
		this.effectiveDate = effectiveDate;
	}


	public int getMaintenanceCycle() {
		return this.maintenanceCycle;
	}

	public void setMaintenanceCycle(int maintenanceCycle) {
		this.maintenanceCycle = maintenanceCycle;
	}

	public String getManufacturer() {
		return this.manufacturer;
	}

	public void setManufacturer(String manufacturer) {
		this.manufacturer = manufacturer;
	}

	public String getModel() {
		return this.model;
	}

	public void setModel(String model) {
		this.model = model;
	}

	public String getName() {
		return this.name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public int getNumber() {
		return this.number;
	}

	public void setNumber(int number) {
		this.number = number;
	}

	public String getOrgCode() {
		return this.orgCode;
	}

	public void setOrgCode(String orgCode) {
		this.orgCode = orgCode;
	}

	public String getProductionArea() {
		return this.productionArea;
	}

	public void setProductionArea(String productionArea) {
		this.productionArea = productionArea;
	}

	public Date getProductionDate() {
		return this.productionDate;
	}

	public void setProductionDate(Date productionDate) {
		this.productionDate = productionDate;
	}

	public String getRemark() {
		return this.remark;
	}

	public void setRemark(String remark) {
		this.remark = remark;
	}

	public String getRoom() {
		return this.room;
	}

	public void setRoom(String room) {
		this.room = room;
	}


	public String getUnit() {
		return this.unit;
	}

	public void setUnit(String unit) {
		this.unit = unit;
	}

	public String getEquipCode() {
		return equipCode;
	}

	public void setEquipCode(String equipCode) {
		this.equipCode = equipCode;
	}

	public String getEquipType() {
		return equipType;
	}

	public void setEquipType(String equipType) {
		this.equipType = equipType;
	}
	
	public int getEquipClassify() {
		return equipClassify;
	}

	public void setEquipClassify(int equipClassify) {
		this.equipClassify = equipClassify;
	}
	
	public String getPosition3d() {
		return position3d;
	}

	public void setPosition3d(String position3d) {
		this.position3d = position3d;
	}

	public String getFloor3d() {
		return floor3d;
	}

	public void setFloor3d(String floor3d) {
		this.floor3d = floor3d;
	}

	public Boolean getIsIndoor() {
		return isIndoor;
	}

	public void setIsIndoor(Boolean isIndoor) {
		this.isIndoor = isIndoor;
	}

	public BigDecimal getWeight() {
		return weight;
	}

	public void setWeight(BigDecimal weight) {
		this.weight = weight;
	}

	@Column(name = "ue4_location")
	public String getUe4Location() {
		return ue4Location;
	}

	public void setUe4Location(String ue4Location) {
		this.ue4Location = ue4Location;
	}

	@Column(name = "ue4_rotation")
	public String getUe4Rotation() {
		return ue4Rotation;
	}

	public void setUe4Rotation(String ue4Rotation) {
		this.ue4Rotation = ue4Rotation;
	}
}