package com.yeejoin.amos.fas.dao.entity;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import java.math.BigDecimal;


/**
 * The persistent class for the risk_level database table.
 */
@Entity
@Table(name = "f_risk_level")
@NamedQuery(name = "RiskLevel.findAll", query = "SELECT r FROM RiskLevel r")
public class RiskLevel extends BasicEntity {
    private static final long serialVersionUID = 1L;

    private String color;

    @Column(name = "create_by")
    private Long createBy;

    @Column(name = "evaluation_model_id")
    private Long evaluationModelId;

    @Column(name = "name")
    private String name;

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Column(name = "level")
    private Integer level;

    @Column(name = "org_code")
    private String orgCode;

    @Column(name = "top_limit")
    private BigDecimal topLimit;

    @Column(name = "down_limit")
    private BigDecimal downLimit;

    private String remark;

    private String severity;

    public RiskLevel() {
    }

    public String getColor() {
        return this.color;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public Long getCreateBy() {
        return this.createBy;
    }

    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    public Integer getLevel() {
        return this.level;
    }

    public void setLevel(Integer level) {
        this.level = level;
    }

    public String getOrgCode() {
        return this.orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getSeverity() {
        return this.severity;
    }

    public void setSeverity(String severity) {
        this.severity = severity;
    }

    public Long getEvaluationModelId() {
        return evaluationModelId;
    }

    public void setEvaluationModelId(Long evaluationModelId) {
        this.evaluationModelId = evaluationModelId;
    }

    public BigDecimal getTopLimit() {
        return topLimit;
    }

    public void setTopLimit(BigDecimal topLimit) {
        this.topLimit = topLimit;
    }

    public BigDecimal getDownLimit() {
        return downLimit;
    }

    public void setDownLimit(BigDecimal downLimit) {
        this.downLimit = downLimit;
    }
}