package com.yeejoin.amos.fas.business.controller;


import java.util.Date;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import com.yeejoin.amos.fas.business.service.intfc.FireStengthService;
import com.yeejoin.amos.fas.core.common.request.CommonPageable;
import com.yeejoin.amos.fas.core.util.CommonResponse;
import com.yeejoin.amos.fas.core.util.CommonResponseUtil;
import com.yeejoin.amos.fas.dao.entity.FireStrength;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

@RestController
@RequestMapping(value = "/api/firestrength")
@Api(tags="消防专职人API")
public class FireStrengthController extends BaseController{


    @Autowired
    FireStengthService fireStengthService;
    //@Authorization(ingore = true)
    @ApiOperation(httpMethod = "POST",value = "添加专职人员", notes = "添加专职人员")
    @RequestMapping(value = "", produces = "application/json;charset=UTF-8", method = RequestMethod.POST)
    public CommonResponse createPoint(@RequestBody FireStrength fireStrength)  throws Exception{

        if(fireStrength == null
                || StringUtils.isEmpty(fireStrength.getUsername())
                || StringUtils.isEmpty(fireStrength.getPhoneNum())
                || StringUtils.isEmpty(fireStrength.getPosition())
                || StringUtils.isEmpty(fireStrength.getCode() ))
            throw new Exception("数据校验失败.");

        fireStrength.setCreateBy(0);
        fireStrength.setCreateDate(new Date());
        return CommonResponseUtil.success(fireStengthService.savePoint(fireStrength));
    }

   // @Authorization(ingore = true)
    @ApiOperation(httpMethod = "PUT",value = "编辑专职人员", notes = "编辑专职人员")
    @RequestMapping(value = "/{id}", produces = "application/json;charset=UTF-8", method = RequestMethod.PUT)
    public CommonResponse udpatePoint(@PathVariable Long id, @RequestBody FireStrength fireStrength) {
        fireStrength.setId(id);
        return CommonResponseUtil.success(fireStengthService.savePoint(fireStrength));
    }

    //@Authorization(ingore = true)
    @ApiOperation(httpMethod = "GET",value = "查询单个专职人员", notes = "查询单个专职人员")
    @RequestMapping(value = "/{id}", produces = "application/json;charset=UTF-8", method = RequestMethod.GET)
    public CommonResponse queryPoint(@PathVariable Long id) {

        return CommonResponseUtil.success(fireStengthService.queryOne(id));
    }


    //@Authorization(ingore = true)
    @ApiOperation(httpMethod = "DELETE",value = "删除专职人员", notes = "查询单个专职人员")
    @RequestMapping(value = "/{ids}", produces = "application/json;charset=UTF-8", method = RequestMethod.DELETE)
    public CommonResponse deletePoint(@PathVariable String  ids) throws Exception {
        String [] idArray = ids.split(",");
        return CommonResponseUtil.success(fireStengthService.deletePoint(idArray));
    }

    //@Authorization(ingore = true)
    @ApiOperation(httpMethod = "GET",value = "分页查询专职人员", notes = "分页查询专职人员")
    @RequestMapping(value = "/page", produces = "application/json;charset=UTF-8", method = RequestMethod.GET)
    public CommonResponse pointList(
            @ApiParam(value = "名称模糊查询", required = false) @RequestParam(required = false)String  name,
            @ApiParam(value = "编号模糊查询", required = false) @RequestParam(required = false)String  code,
                                    @RequestParam int pageNumber,
                                    @RequestParam  int pageSize
    ) {
        CommonPageable commonPageable = new CommonPageable(pageNumber,pageSize);

        return CommonResponseUtil.success(fireStengthService.queryByFireEquimt(StringUtils.trimToNull(name),StringUtils.trimToNull(code),commonPageable));
    }

}
