package com.yeejoin.amos.fas.business.controller;

import com.yeejoin.amos.fas.business.service.intfc.Node3dVoService;
import com.yeejoin.amos.fas.core.util.CommonResponse;
import com.yeejoin.amos.fas.core.util.CommonResponseUtil;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping("/api/node3d")
@Api(tags="3d模型数据")
public class Node3dVoController extends BaseController {
	private final Logger log = LoggerFactory.getLogger(Node3dVoController.class);


	@Autowired
	Node3dVoService node3dVoService;



	/**
	 * 同步新增的3d数据
	 *
	 * @param dataType
	 * @return
	 */
	@ApiOperation(httpMethod = "POST",value = "同步新增的3d数据", notes = "同步新增的3d数据")
	@RequestMapping(value = "/incremental/{dataType}", produces = "application/json;charset=UTF-8", method = RequestMethod.POST)
	public CommonResponse incrementalCreate(@ApiParam(value = "数据类型" ,required = true) @PathVariable String  dataType) {
		node3dVoService.incrementalCreate(dataType);
		return CommonResponseUtil.success("SUCCESS");
	}


	/**
	 * 同步已经删除的的3d数据
	 *
	 * @return
	 */
	@ApiOperation(httpMethod = "DELETE",value = "同步已经删除的的3d数据", notes = "同步已经删除的的3d数据")
	@RequestMapping(value = "/incremental/{dataType}", produces = "application/json;charset=UTF-8", method = RequestMethod.DELETE)
	public CommonResponse incrementalRemove(@ApiParam(value = "数据类型" ,required = true) @PathVariable String  dataType) {
		node3dVoService.incrementalRemove(dataType);
		return CommonResponseUtil.success("SUCCESS");
	}




	/**
	 * 同步需要更新的的3d数据
	 *
	 * @return
	 */
	@ApiOperation(httpMethod = "PUT",value = "同步需要更新的的3d数据", notes = "同步需要更新的的3d数据")
	@RequestMapping(value = "/incremental/{dataType}", produces = "application/json;charset=UTF-8", method = RequestMethod.PUT)
	public CommonResponse incrementalUpdate(@ApiParam(value = "数据类型" ,required = true) @PathVariable String  dataType)  throws Exception{
		node3dVoService.incrementalUpdate(dataType);
		return CommonResponseUtil.success("SUCCESS");
	}


	/**
	 * 同步指定的数据类型，增加，删除，更新
	 *
	 * @return
	 */
	@ApiOperation(httpMethod = "PUT",value = "同步需要更新的的3d数据", notes = "同步需要更新的的3d数据")
	@RequestMapping(value = "/incremental/dataType/{dataType}", produces = "application/json;charset=UTF-8", method = RequestMethod.PUT)
	public CommonResponse incrementalDataType(@ApiParam(value = "数据类型" ,required = true) @PathVariable String  dataType)  throws Exception{
		node3dVoService.incrementalDataType(dataType);
		return CommonResponseUtil.success("SUCCESS");
	}


	/**
	 * 对所有数据类型进行同步，新增，更新，删除
	 *
	 * @return
	 */
	@ApiOperation(httpMethod = "PUT",value = "对所有数据类型进行同步，新增，更新，删除", notes = "对所有数据类型进行同步，新增，更新，删除")
	@RequestMapping(value = "/whole/incremental", produces = "application/json;charset=UTF-8", method = RequestMethod.PUT)
	public CommonResponse wholeIncremental()  throws Exception{
		node3dVoService.wholeIncremental();
		return CommonResponseUtil.success("SUCCESS");
	}


}
