package com.yeejoin.amos.fas.business.controller;

import com.yeejoin.amos.fas.business.param.CommonPageInfoParam;
import com.yeejoin.amos.fas.business.param.RiskFmeaParam;
import com.yeejoin.amos.fas.business.service.intfc.IFmeaService;
import com.yeejoin.amos.fas.business.service.intfc.IRiskSourceService;
import com.yeejoin.amos.fas.business.util.CommonPageParamUtil;
import com.yeejoin.amos.fas.business.vo.ReginParams;
import com.yeejoin.amos.fas.client.invoke.RsDataQueue;
import com.yeejoin.amos.fas.core.common.request.CommonPageable;
import com.yeejoin.amos.fas.core.common.request.CommonRequest;
import com.yeejoin.amos.fas.core.util.CommonResponse;
import com.yeejoin.amos.fas.core.util.CommonResponseUtil;
import com.yeejoin.amos.fas.dao.entity.Fmea;
import com.yeejoin.amos.fas.dao.entity.RiskSource;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.*;

import java.util.HashMap;
import java.util.List;

@RestController
@RequestMapping("/api/riskModel")
@Api(tags = "风险模型api")
public class RiskModelController extends BaseController {

    private final Logger log = LoggerFactory.getLogger(RiskLevelController.class);

    @Autowired
    private IRiskSourceService riskSourceService;

    @Autowired
    private IFmeaService fmeaService;

    @ApiOperation(value = "根据父类编号获取子类风险点类型", notes = "根据父类编号获取子类风险点类型")
    @GetMapping(value = "/riskSource/getChildTypeByPid")
    public CommonResponse getChildTypeByPid(@ApiParam(value = "风险模型对象", required = true) @RequestParam Long riskSourceId) {
        try {
            Integer type = riskSourceService.getChildTypeByPid(riskSourceId);
            return CommonResponseUtil.success(type);
        } catch (Exception e) {
            log.error("根据父类编号获取子类风险点类型异常", e);
            return CommonResponseUtil.failure("系统繁忙，请稍后再试");
        }
    }


    /**
     * 风险模型新增及维护
     */
    @ApiOperation(httpMethod = "POST", value = "风险模型新增及维护", notes = "风险模型新增及维护")
    @RequestMapping(value = "/riskSource/editRiskSource", produces = "application/json;charset=UTF-8", method = RequestMethod.POST)
    public CommonResponse editRiskSource(@ApiParam(value = "风险模型对象", required = true) @RequestBody RiskSource param) {
        try {
            Integer type = riskSourceService.getChildTypeByPid(param.getParentId());
            String isRegion = param.getIsRegion();
            if (type.equals(1) && isRegion.equals("FALSE")) {
                return CommonResponseUtil.failure("该区域下只能添加区域");
            }
            if (type.equals(2) && isRegion.equals("TRUE")) {
                return CommonResponseUtil.failure("该区域下只能添加风险点");
            }
            AgencyUserModel user = getUserInfo();
			ReginParams reginParams =getSelectedOrgInfo();
			String compCode=getOrgCode(reginParams);
            HashMap<String, Object> map = new HashMap<>();
            map.put("org_code", compCode);
            map.put("user_id", user.getUserId());
            map.put("param", param);
            return CommonResponseUtil.success(riskSourceService.editRiskSource(map));
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return CommonResponseUtil.failure("风险模型新增及维护失败：" + e.getMessage());
        }
    }

    /**
     * 风险模型删除
     */
    @ApiOperation(httpMethod = "POST", value = "风险模型删除", notes = "风险模型删除")
    //@Authorization(ingore = true)
    @RequestMapping(value = "/riskSource/deleteRiskSource", produces = "application/json;charset=UTF-8", method = RequestMethod.POST)
    public CommonResponse deleteRiskSource(@ApiParam(value = "风险模型id", required = true) @RequestBody Long[] riskSourceId) {
        try {
            riskSourceService.deleteRiskSource(riskSourceId);
            return CommonResponseUtil.success();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return CommonResponseUtil.failure("风险模型删除失败：" + e.getMessage());
        }
    }

    /**
     * 风险点列表分页查询
     */
    @ApiOperation(httpMethod = "POST", value = "风险点列表分页查询", notes = "风险点列表分页查询")
    @RequestMapping(value = "/riskSource/list", produces = "application/json;charset=UTF-8", method = RequestMethod.POST)
    public CommonResponse queryRiskSourceByPage(
            @ApiParam(value = "查询条件") @RequestBody(required = false) List<CommonRequest> queryRequests,
            @ApiParam(value = "分页参数", required = true) CommonPageable commonPageable) {
        CommonPageInfoParam param = CommonPageParamUtil.fillCommonPageInfoParam(queryRequests, commonPageable);
        Page<HashMap<String, Object>> riskSourceList = riskSourceService.queryRiskSourceByPage(param);
        return CommonResponseUtil.success(riskSourceList);
    }

    /**
     * Fmea模型新增及维护
     */
    @ApiOperation(httpMethod = "POST", value = "Fmea模型新增及维护", notes = "Fmea模型新增及维护")
    @RequestMapping(value = "/fmea/editFmea", produces = "application/json;charset=UTF-8", method = RequestMethod.POST)
    public CommonResponse editFmea(@ApiParam(value = "Fmea模型对象", required = true) @RequestBody List<Fmea> params) {
        try {
        	AgencyUserModel user = getUserInfo();
            HashMap<String, Object> map = new HashMap<>();
            map.put("user_id", user.getUserId());
            map.put("fmeas", params);
            fmeaService.editFmea(map);
            RsDataQueue rs = RsDataQueue.getInstance();
            params.forEach(param -> {
                if (!ObjectUtils.isEmpty(param.getId())) {
                    rs.addUpdateMessage(param.getId());
                }
            });
            return CommonResponseUtil.success();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return CommonResponseUtil.failure("Fmea模型新增及维护失败：" + e.getMessage());
        }
    }

    /**
     * Fmea模型删除
     */
    @ApiOperation(httpMethod = "POST", value = "Fmea模型删除", notes = "Fmea模型删除")
    @RequestMapping(value = "/fmea/deleteFmea", produces = "application/json;charset=UTF-8", method = RequestMethod.POST)
    public CommonResponse deleteFmea(@ApiParam(value = "Fmea模型id", required = true) @RequestBody RiskFmeaParam param) {
        try {
            Long[] fmeaIds = param.getFmeaIds();
            fmeaService.deleteFmea(fmeaIds);
            if (fmeaIds.length > 0 && param.getRiskSourceId() != null) {
                RsDataQueue rsDataQueue = RsDataQueue.getInstance();
                rsDataQueue.addDeleteMessage(param.getRiskSourceId());
            }
            return CommonResponseUtil.success();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return CommonResponseUtil.failure("Fmea模型删除失败：" + e.getMessage());
        }
    }

    /**
     * Fmea列表分页查询
     */
    @ApiOperation(httpMethod = "POST", value = "Fmea列表分页查询", notes = "Fmea列表分页查询")
    @RequestMapping(value = "/fmea/list", produces = "application/json;charset=UTF-8", method = RequestMethod.POST)
    public CommonResponse queryFmeaByPage(@ApiParam(value = "查询条件") @RequestBody(required = false) List<CommonRequest> queryRequests,
                                          @ApiParam(value = "分页参数", required = true) CommonPageable commonPageable) {
        CommonPageInfoParam param = CommonPageParamUtil.fillCommonPageInfoParam(queryRequests, commonPageable);
        Page<HashMap<String, Object>> fmeaList = fmeaService.queryFmeaList(param);
        return CommonResponseUtil.success(fmeaList);
    }

    @ApiOperation(value = "Fmea是否关联对象查询", notes = "Fmea是否关联对象查询")
    @GetMapping(value = "/fmea/{ids}/controlObjCount")
    public CommonResponse queryFmeaControlObj(@ApiParam(value = "fmea ids") @PathVariable(value = "ids", required = true) String[] ids) {
        return CommonResponseUtil.success(fmeaService.queryControlObjCount(ids));
    }
}
