package com.yeejoin.amos.fas.business.dao.mapper;

import com.yeejoin.amos.fas.business.param.CommonPageInfoParam;
import com.yeejoin.amos.fas.dao.entity.Fmea;
import org.apache.ibatis.annotations.Param;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

public interface FmeaMapper extends BaseMapper {

    /**
     * Fmea查询，分页查询统计用
     *
     * @param param
     * @return
     */
    long countPageData(CommonPageInfoParam param);

    /**
     * 危险因素分页查询
     *
     * @param param
     * @return
     */
    List<HashMap<String, Object>> queryFmeaPage(CommonPageInfoParam param);


    /**
     * FMEA信息列表
     */
    List<Map> queryForFmeaList(@Param("riskSourceId") Long riskSourceId);

    Fmea getById(Long id);

    List<Fmea> listByRiskSourceId(Long riskSourceId);

    void updateRpn(Fmea fmea);
}
