package com.yeejoin.amos.fas.business.service.impl;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.yeejoin.amos.fas.business.dao.repository.ITopographyLineDao;
import com.yeejoin.amos.fas.business.service.intfc.ITopographyLineService;
import com.yeejoin.amos.fas.dao.entity.TopographyLine;

@Service("topographyLineService")
public class ITopographyLineServiceImpl implements ITopographyLineService{

	@Autowired
	private ITopographyLineDao topographyLineDao;

	@Override
	public List<TopographyLine> getLinksByAppId(String appId) {
		return topographyLineDao.findByAppId(appId);
	}

	@Override
	public void saveLines(List<TopographyLine> lineData) {
		topographyLineDao.saveAll(lineData);
	}

	@Override
	public void deleteLine(String id) {
		TopographyLine line = topographyLineDao.findById(id);
		if(line != null) {
			topographyLineDao.delete(line);
		}
	}
	
	
}
