package com.yeejoin.amos.fas.business.service.impl;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.yeejoin.amos.fas.business.dao.repository.ITopographyLineDao;
import com.yeejoin.amos.fas.business.dao.repository.ITopographyNodeDao;
import com.yeejoin.amos.fas.business.dao.repository.ITopographyNodeDetailDao;
import com.yeejoin.amos.fas.business.service.intfc.ITopographyNodeService;
import com.yeejoin.amos.fas.dao.entity.TopographyLine;
import com.yeejoin.amos.fas.dao.entity.TopographyNode;
import com.yeejoin.amos.fas.dao.entity.TopographyNodeDetail;

@Service("topographyNodeService")
public class ITopographyNodeServiceImpl implements ITopographyNodeService{
	
	@Autowired
	private ITopographyNodeDao nodeDao;
	
	@Autowired
	private ITopographyNodeDetailDao nodeDetailDao;
	
	@Autowired
	private ITopographyLineDao lineDao;

	@Override
	public List<TopographyNode> getNodesByAppId(String appId) {
		return nodeDao.findByAppId(appId);
	}

	@Override
	public void saveNodes(List<TopographyNode> nodeData) {
		nodeDao.saveAll(nodeData);
	}

	@Override
	public TopographyNodeDetail getNodeDetailById(String nodeid) {
		return nodeDetailDao.findByNodeid(nodeid);
	}

	@Override
	public TopographyNodeDetail saveNodeDetail(TopographyNodeDetail nodeDetail) {
		TopographyNodeDetail curNodeDetail = nodeDetailDao.findByNodeid(nodeDetail.getNodeid());
		if(curNodeDetail == null) {
			curNodeDetail = new TopographyNodeDetail();
			curNodeDetail.setNodeid(nodeDetail.getNodeid());
		}
		curNodeDetail.setNodeDetail(nodeDetail.getNodeDetail());
		TopographyNodeDetail save = nodeDetailDao.save(curNodeDetail);
		return save;
	}

	@Override
	public void deleteNode(String id) {
		TopographyNode node = nodeDao.findById(id);
		if(node != null) {
			String key = node.getKey();
			nodeDao.delete(node);
			List<TopographyLine> lines = lineDao.findByKey(key);
			if(lines != null && lines.size() > 0) {
				lineDao.deleteAll(lines);
			}
		}
	}

	@Override
	public TopographyNode queryByKeyAndAppId(String nodekey, String appId) {
		return nodeDao.findByKeyAndAppId(nodekey,appId);
	}

	@Override
	public int queryMaxKeyByAppId(String appId) {
		return nodeDao.queryMaxKeyByAppId(appId);
	}


}
