package com.yeejoin.amos.fas.business.service.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.stereotype.Service;

import com.yeejoin.amos.fas.business.dao.mapper.RiskLevelMapper;
import com.yeejoin.amos.fas.business.dao.repository.IRiskLevelDao;
import com.yeejoin.amos.fas.business.dao.repository.IRiskSourceDao;
import com.yeejoin.amos.fas.business.param.CommonPageInfoParam;
import com.yeejoin.amos.fas.business.service.intfc.IRiskLevelService;
import com.yeejoin.amos.fas.dao.entity.RiskLevel;
import com.yeejoin.amos.fas.dao.entity.RiskSource;
import com.yeejoin.amos.fas.exception.YeeException;
@Service("riskLevelService")
public class RiskLevelServiceImpl implements IRiskLevelService {
	@Autowired 
	RiskLevelMapper riskLevelMapper;
	@Autowired
	IRiskLevelDao  iRiskLevelDao;
	@Autowired
	IRiskSourceDao iRiskSourceDao;
	
	@Override
	public Page<HashMap<String, Object>> queryRiskLevelPage(CommonPageInfoParam param) {
		long total = riskLevelMapper.countPageData(param);
		List<HashMap<String, Object>> content = riskLevelMapper.queryRiskLevelPage(param);
		Page<HashMap<String, Object>> result = new PageImpl<>(content, param, total);
		return result;
	}

	@Override
	public void editRiskLevel(HashMap<String, Object>  map) {
		RiskLevel param =  (RiskLevel) map.get("param");
		String orgCode = map.get("org_code") == null ? "":map.get("org_code").toString();
		String userId = map.get("user_id")== null ? "0":map.get("user_id").toString();
		param.setOrgCode(orgCode);
		param.setCreateBy(Long.parseLong(userId));
		param.setCreateDate(new Date());
		iRiskLevelDao.save(param);
	}

	@Override
	public void detRiskLevel(Long[] param) {
		//1.校验
		for(Long id : param){
			checkBeforeDet(id);
		}
		//2.删除
		iRiskLevelDao.deleteAllByIds(param);

	}

	/**
	 * 删除前校验
	 * @param id
	 */
	private void checkBeforeDet(Long id) {
		List<RiskSource> list = iRiskSourceDao.findByRiskLevelId(id);
		if(null !=list && list.size() >0){
			throw new YeeException("风险点"+list.get(0).getName()+"在使用中，不能删除");
		}
	}

	@Override
	public List<RiskLevel> queryRiskLevel(Long id) {
		List<RiskLevel> list = new ArrayList<RiskLevel>();
		if(null == id){
			list = iRiskLevelDao.findAll();
		}else{
			list = iRiskLevelDao.findByEvaluationModelId(id);
		}
		return list;
	}

	@Override
	public Long countRepeatData(RiskLevel param) {
		// TODO Auto-generated method stub
		
		return riskLevelMapper.countRepeatData(param);
	}

}
