package com.yeejoin.amos.fas.business.service.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.stereotype.Service;

import com.yeejoin.amos.fas.business.dao.mapper.Node3dVoMapper;
import com.yeejoin.amos.fas.business.dao.mapper.WaterResourceMapper;
import com.yeejoin.amos.fas.business.dao.repository.IWaterResourceDao;
import com.yeejoin.amos.fas.business.dao.repository.IWaterResourceEquipmentDao;
import com.yeejoin.amos.fas.business.service.intfc.IWaterResourceService;
import com.yeejoin.amos.fas.core.common.request.CommonPageable;
import com.yeejoin.amos.fas.core.util.StringUtil;
import com.yeejoin.amos.fas.dao.entity.WaterResource;
import com.yeejoin.amos.fas.dao.entity.WaterResourceEquipment;

@Service("waterResourceService")
public class WaterResourceServiceImpl implements IWaterResourceService {



	@Autowired
	IWaterResourceDao iWaterResourceDao;

	@Autowired
	WaterResourceMapper waterResourceMapper;
	
	@Autowired
	IWaterResourceEquipmentDao iWaterResourceEquipmentDao;


	@Autowired
	Node3dVoMapper node3dVoMapper;
	
	public WaterResource save(WaterResource waterResource)
	{
		Long id = waterResource.getId();
		waterResource = iWaterResourceDao.saveAndFlush(waterResource);
		if(id ==null || id == 0){
			node3dVoMapper.incrementalCreateWater(waterResource.getId());
		}else{
			node3dVoMapper.incrementalUpdateWater(id);
		}
		return waterResource;
	}


	public Map queryOne(Long id)
	{
		return waterResourceMapper.queryOne(id);
	}

	public String [] delete(String []idArray) throws Exception
	{
		for(String id:idArray)
		{
			Optional<WaterResource> waterResource1 = iWaterResourceDao.findById(Long.parseLong(id));
			WaterResource waterResource = null;
			if(waterResource1.isPresent()){
				waterResource=waterResource1.get();
			}
			if(waterResource != null)
			{
				this.iWaterResourceDao.deleteById(Long.parseLong(id));
				node3dVoMapper.incrementalDeleteWater(Long.parseLong(id));
			}else
			{
				throw new Exception("找不到指定的监测点:"+id);
			}
		}

		return idArray;
	}


		public Page queryForPage(String username,String code,String  type, CommonPageable pageable)
	{
		Long total = waterResourceMapper.queryCountForPage(username,code,type);
		List<Map> content = waterResourceMapper.queryForPage(username,code,type,pageable.getOffset(),pageable.getPageSize());
		Page result = new PageImpl(content,pageable,total);
		return result;
	}


		@Override
		public void saveBindFireEquipment(List<WaterResourceEquipment> waterResourceEquipments) {
			// TODO Auto-generated method stub
			List<WaterResourceEquipment> saveList = new ArrayList<WaterResourceEquipment>();
			for(WaterResourceEquipment waterResourceEquipment:waterResourceEquipments){
				int count = iWaterResourceEquipmentDao.countByWaterResourceIdAndFireEquipmentId(waterResourceEquipment.getWaterResourceId(),waterResourceEquipment.getFireEquipmentId());
				if(count==0){
					saveList.add(waterResourceEquipment);
				}
			}
			iWaterResourceEquipmentDao.saveAll(saveList);
		}


		@Override
		public void deleteBindFireEquipment(List<WaterResourceEquipment> waterResourceEquipments) {
			// TODO Auto-generated method stub
			List<WaterResourceEquipment> deleteList = new ArrayList<WaterResourceEquipment>();
			for(WaterResourceEquipment waterResourceEquipment:waterResourceEquipments){
				WaterResourceEquipment saveWaterResourceEquipment = iWaterResourceEquipmentDao.findByWaterResourceIdAndFireEquipmentId(waterResourceEquipment.getWaterResourceId(),waterResourceEquipment.getFireEquipmentId());
				if(StringUtil.isNotEmpty(saveWaterResourceEquipment)){
					deleteList.add(waterResourceEquipment);
				}
			}
			iWaterResourceEquipmentDao.deleteAll(deleteList);
		}


		@Override
		public Page queryBindFireEquemtPage(Long waterResourceId, CommonPageable pageable) {
			Long total = waterResourceMapper.queryCountForBindFireEqumntPage(waterResourceId);
			List<Map> content = waterResourceMapper.queryForBindFireEqumntPage(waterResourceId, pageable.getOffset(),
					pageable.getPageSize());
			return new PageImpl(content, pageable, total);
		}


		@Override
		public Object queryForList() {
			return iWaterResourceDao.findAll();
		}






}
