package com.yeejoin.amos.fas.business.service.model;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;


public class RiskSourceRo extends BasicsRo {


    private static final long serialVersionUID = 1L;

    private String id;

    /**
     * 风险点名称
     */
    private String name;
    /**
     * 风险点编号
     */
    private String code;
    /**
     * 风险点来源（ProtalDataRo、FireEquimentDataRo、child）
     */
    private String from;
    /**
     * 状态
     */
    private String nodeState;//风险源状态
    /**
     * 上一次状态
     */
    private String originalNodeState;
    /**
     * 风险点级别
     */
    private Integer riskLevel;
    /**
     * RPNr值
     */
    private BigDecimal rpn;
    /**
     * RPNi值
     */
    private BigDecimal rpni;

    /**
     * 风险因素，多条换行
     */
    private String riskFactor;

    /**
     * 是否区域节点
     */
    private String  isRegion;



    private Integer regionMaxLevel;

    /**
     * 计算RPNi值，保存所有风险因素得i值，key统一为：rpni
     */
    private List<BigDecimal> RPNiSum;
    /**
     * 计算RPNr值
     */

    private String riskState;//风险点状态

    private BigDecimal rg;

    /**
     * up、down、no
     */
    private String levelChangeType;


    public String getRiskState() {
        return riskState;
    }

    public void setRiskState(String riskState) {
        this.riskState = riskState;
    }

    public Integer getRegionMaxLevel() {
        return regionMaxLevel;
    }

    public void setRegionMaxLevel(Integer regionMaxLevel) {
        this.regionMaxLevel = regionMaxLevel;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getFrom() {
        return from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public String getNodeState() {
        return nodeState;
    }

    public void setNodeState(String nodeState) {
        this.nodeState = nodeState;
    }

    public String getOriginalNodeState() {
        return originalNodeState;
    }

    public void setOriginalNodeState(String originalNodeState) {
        this.originalNodeState = originalNodeState;
    }

    public Integer getRiskLevel() {
        return riskLevel;
    }

    public void setRiskLevel(Integer riskLevel) {
        this.riskLevel = riskLevel;
    }

    public BigDecimal getRpn() {
        return rpn;
    }

    public void setRpn(BigDecimal rpn) {
        this.rpn = rpn;
    }

    public BigDecimal getRpni() {
        return rpni;
    }

    public void setRpni(BigDecimal rpni) {
        this.rpni = rpni;
    }

    public String getRiskFactor() {
        return riskFactor;
    }

    public void setRiskFactor(String riskFactor) {
        this.riskFactor = riskFactor;
    }

    public String getIsRegion() {
        return isRegion;
    }

    public void setIsRegion(String isRegion) {
        this.isRegion = isRegion;
    }

    public List<BigDecimal> getRPNiSum() {
        return RPNiSum;
    }

    public void setRPNiSum(List<BigDecimal> RPNiSum) {
        this.RPNiSum = RPNiSum;
    }

}
