/**
 * 
 */
package com.yeejoin.amos.fas.context;

import org.apache.log4j.Logger;
import org.springframework.context.ApplicationContext;

import com.yeejoin.amos.fas.business.constants.FasConstant;

/**
 * iot-spring上下文
 * 
 * @author as-youjun
 *
 */
public class IotContext {

	/**
	 * 实例
	 */
	private static IotContext instance;

	/**
	 * spring上下文
	 */
	private ApplicationContext applicationContext;

	/**
	 * 构造方法
	 */
	private IotContext() {
		Logger.getLogger(this.getClass()).debug(FasConstant.CONSTRUCTOR);
	}

	/**
	 * 获取单例
	 * 
	 * @return
	 */
	public static synchronized IotContext getInstance() {
		if (instance == null) {
			instance = new IotContext();
		}
		return instance;
	}

	/**
	 * 设置上下文
	 * 
	 * @param applicationContext
	 */
	public void setApplicationContext(ApplicationContext applicationContext) {
		this.applicationContext = applicationContext;
	}

	/**
	 * 获取上下文
	 * 
	 * @param beanName
	 * @return
	 */
	public Object getBean(String beanName) {
		return applicationContext.getBean(beanName);
	}

	/**
	 * 获取上下文
	 * 
	 * @param requiredType
	 * @return
	 */
	public Object getBean(Class<?> requiredType) {
		return applicationContext.getBean(requiredType);
	}

}
