package com.yeejoin.amos;

import java.io.IOException;
import java.net.URISyntaxException;

import org.apache.log4j.Logger;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.beans.BeansException;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.ServletComponentScan;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.netflix.eureka.EnableEurekaClient;
import org.springframework.cloud.netflix.hystrix.EnableHystrix;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.core.env.Environment;
import org.springframework.data.jpa.repository.config.EnableJpaAuditing;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.transaction.annotation.EnableTransactionManagement;

import com.yeejoin.amos.fas.client.invoke.RsDataQueue;
import com.yeejoin.amos.fas.context.IotContext;

import springfox.documentation.swagger2.annotations.EnableSwagger2;

/**
 * 
 * <pre>
 * 服务启动类
 * </pre>
 *
 * @author amos
 * @version $Id: AmosOPStart.java, v 0.1 2018年11月26日 下午4:56:29 amos Exp $
 */
@EnableHystrix
@EnableScheduling
@SpringBootApplication
@EnableTransactionManagement
@EnableConfigurationProperties
@EnableSwagger2
@ServletComponentScan
@EnableJpaAuditing
@EnableDiscoveryClient
@EnableFeignClients
@EnableAsync
@EnableEurekaClient
@ComponentScan({"org.typroject","com.yeejoin.amos"})
@MapperScan(basePackages = { "com.yeejoin.amos.fas.business.dao.mapper" })
public class YeeAmosFireAutoSysStart  implements ApplicationContextAware
{

	private static final Logger log = Logger.getLogger(YeeAmosFireAutoSysStart.class);

	/**
	 * 启动amosop-server
	 *
	 * @param args
	 * @throws IOException
	 * @throws URISyntaxException
	 */
	public static void main(String[] args)
	{
		log.info("start Service..........");
		try
		{
			SpringApplication application = new SpringApplication(YeeAmosFireAutoSysStart.class);
			Environment environment = application.run(args).getEnvironment();
			log.info("SwaggerUI: 	http://localhost:"
					+ environment.getProperty("server.port") + "/swagger-ui.html");
		}
		catch (Exception e)
		{
			System.out.println("error occur when run server! " + e);
		}
	}
	
	/**
     * 获取并缓存上下文
     */
    @Override
    public void setApplicationContext(ApplicationContext applicationContext)
            throws BeansException {
        // 缓存spring上下文
        IotContext.getInstance().setApplicationContext(applicationContext);
        RsDataQueue.getInstance().start();
    }
}