package com.yeejoin.amos.fas.common.enums;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author wjk
 */

public enum EquipClassifyEnum {
    EQUIPMENT("设备类","0"),
    CONSUMABLES("耗材类;","1"),
    VIDEO("视频监控", "2"),
    FIRE_FIGHTING("灭火器材", "3");

    /**
     * 名称，描述
     */
    private String name;
    /**
     * 编码
     */
    private String code;


    private EquipClassifyEnum(String name, String code){
        this.name = name;
        this.code = code;
    }

    public static EquipClassifyEnum getEnum(String code) {
        EquipClassifyEnum checkStatusEnum = null;
        for(EquipClassifyEnum type: EquipClassifyEnum.values()) {
            if (type.getCode().equals(code)) {
                checkStatusEnum = type;
                break;
            }
        }

        return checkStatusEnum;
    }

    public static List<Map<String,String>> getEnumList() {
        List<Map<String,String>> nameList = new ArrayList<>();
        for (EquipClassifyEnum c: EquipClassifyEnum.values()) {
            Map<String, String> map = new HashMap<String, String>();
            map.put("name", c.getName());
            map.put("code", c.getCode());
            nameList.add(map);
        }
        return nameList;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
}

