package com.yeejoin.amos.fas.dao.entity;


import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;

@Entity
@Table(name = "contingency_plan_instance")
@TableName("contingency_plan_instance")
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = true)
public class ContingencyPlanInstance extends BusinessEntity{


    private static final long serialVersionUID = 292334653532432432L;


    /**
     * id
     */
    @Id
    @GeneratedValue(generator = "uuid")
    @GenericGenerator(name = "uuid", strategy = "uuid2")
    @Column(name = "id", nullable = false, length = 36)
    protected String id;

    @Column(name = "record_type")
    private String recordType;//	记录类型：消息MESSAGE，操作OPERATE ,回复消息REPLYMESSAGE

    @Column(name = "content")
    private String content	    ;//	记录内容：文本信息或者json数据


    @Column(name = "category")
    private String category;//一级分类


    @Column(name = "icon")
    private String icon	    ;	//图标,url，或者文件名
    @Column(name = "sort")
    private Integer sort	    ;//	所有节点一起的排序号

    @Column(name = "sequence_num")
    private String sequenceNum	;//	用于显示的序号

    @Column(name = "batch_no")
    private String batchNo	;//	预案实例编号,暂时无法区分多个火灾，暂时存储报警设备id

    @Column(name = "tips")
    private String tips;

    @Column(name = "runstate")
    private Boolean runstate;

    @Column(name = "file_path")
    private String filePath; //文件名称

    @Column(name = "file_type")
    private String fileType;// 文件类型

    @Column(name = "role_name")
    private String roleName; //角色名称

    @Column(name = "role_code")
    private String roleCode; //角色编码

    @Column(name = "start_user_name")
    private String startUserName; //人员名称

    @Column(name = "start_user_id")
    private String startUserId; //人员ID

    @Column(name = "person_img")
    private String personImg;

    @Column(name = "task_sort")
    private Integer taskSort;

    @Column(name = "step_code")
    private String stepCode;

    public void setTaskSort(Integer taskSort) {
        this.taskSort = taskSort;
    }

    public void setStepCode(String stepCode) {
        this.stepCode = stepCode;
    }

    public Integer getTaskSort() {
        return taskSort;
    }

    public String getStepCode() {
        return stepCode;
    }

    public String getPersonImg() {
        return personImg;
    }

    public void setPersonImg(String personImg) {
        this.personImg = personImg;
    }

    public String getFilePath() {
        return filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public String getFileType() {
        return fileType;
    }

    public void setFileType(String fileType) {
        this.fileType = fileType;
    }

    public String getRoleName() {
        return roleName;
    }

    public void setRoleName(String roleName) {
        this.roleName = roleName;
    }

    public String getRoleCode() {
        return roleCode;
    }

    public void setRoleCode(String roleCode) {
        this.roleCode = roleCode;
    }

    public String getStartUserName() {
        return startUserName;
    }

    public void setStartUserName(String startUserName) {
        this.startUserName = startUserName;
    }

    public String getStartUserId() {
        return startUserId;
    }

    public void setStartUserId(String startUserId) {
        this.startUserId = startUserId;
    }

    public Boolean getRunstate() {
        return runstate;
    }

    public void setRunstate(Boolean runstate) {
        this.runstate = runstate;
    }

    public String getTips() {
        return tips;
    }

    public void setTips(String tips) {
        this.tips = tips;
    }

    public String getRecordType() {
        return recordType;
    }


    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getCategory() {
        return category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public void setRecordType(String recordType) {
        this.recordType = recordType;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getIcon() {
        return icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public Integer getSort() {
        return sort;
    }

    public void setSort(Integer sort) {
        this.sort = sort;
    }

    public String getSequenceNum() {
        return sequenceNum;
    }

    public void setSequenceNum(String sequenceNum) {
        this.sequenceNum = sequenceNum;
    }


    public String getBatchNo() {
        return batchNo;
    }

    public void setBatchNo(String batchNo) {
        this.batchNo = batchNo;
    }
}
