package com.yeejoin.amos.fas.dao.entity;

import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import java.util.Date;

/**
 * c_plan_detail
 * @author
 */
@Data
@Entity
@Table(name="c_plan_detail")
@NamedQuery(name="PlanDetail.findAll", query="SELECT e FROM PlanDetail e")
public class PlanDetail extends BasicEntity {

    /**
     * 预案名称
     */
    @Column(name="plan_name")
    private String planName;

    /**
     * 预案编号
     */
    private String code;

    /**
     * 预案分类id
     */
    @Column(name="classify_id")
    private Long classifyId;

    /**
     * 适用范围
     */
    @Column(name="plan_range")
    private String planRange;

    /**
     * 编写部门
     */
    @Column(name="edit_org_name")
    private String editOrgName;

    /**
     * 版次
     */
    private String edition;

    /**
     * 实施时间
     */
    @Column(name="implementation_time")
    private Date implementationTime;

    /**
     * 备注
     */
    private String remark;

    /**
     * 预案状态
     */
    private Integer status;

    /**
     * 创建人
     */
    private String creator;

    /**
     * 修改人
     */
    private String reviser;

    /**
     * 修改时间
     */
    @Column(name="update_time")
    private Date updateTime;

    /**
     * 部门code
     */
    @Column(name="org_code")
    private String orgCode;

    /**
     * 删除状态（0、正常，1、删除）
     */
    @Column(name="is_delete")
    private Boolean isDelete;

    /**
     * 录入时间
     */
    @Column(name="input_time")
    private Date inputTime;

    private static final long serialVersionUID = 1L;
}