package com.yeejoin.amos.fas.dao.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import java.util.Date;

/**
 * c_plan_operation_record
 * @author
 */
@Data
@Entity
@Table(name="c_plan_operation_record")
@NamedQuery(name="PlanOperationRecord.findAll", query="SELECT e FROM PlanOperationRecord e")
@TableName("c_plan_operation_record")
public class PlanOperationRecord extends BasicEntity {

    /**
     * 预案ID
     */
    @Column(name="plan_id")
    private Long planId;

    /**
     * 运行模式（0、模拟，1、自动）
     */
    @Column(name="plan_pattern")
    private Integer planPattern;

    /**
     * 开始时间
     */
    @Column(name="start_time")
    private Date startTime;

    /**
     * 结束时间
     */
    @Column(name="end_time")
    private Date endTime;

    /**
     * 批次号
     */
    @Column(name="batch_no")
    private String batchNo;

    /**
     * 是否删除
     */
    @Column(name="is_delete")
    private Boolean isDelete;

    /**
     * 运行状态（0、运行中，1、完毕，3、中断）
     */
    private Integer status;
    /**
     * 启动人名称
     */
    @Column(name="start_user_name")
    private String startUserName;
    /**
     * 启动人id
     */
    @Column(name="strat_user_id")
    private String startUserId;
    /**
     * 装备code
     */
    @Column(name="equipment_code")
    private String equipmentCode;
    /**
     * 执行方式（0、预案验证 1、火灾处置）
     */
    @Column(name="execution_type")
    private Integer executionType;
    /**
     * 装备名称
     */
    @Column(name="equipment_name")
    private String equipmentName;

    /**
     * 装备id
     */
    @Column(name="equipment_id")
    private Long equipmentId;
    /**
     * 电力装备id
     */
    @Column(name="fire_equipment_id")
    private Long fireEquipmentId;
    private static final long serialVersionUID = 1L;
}