package com.yeejoin.amos.fas.business.action;

import com.yeejoin.amos.fas.business.service.intfc.IEquipmentHandlerService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

import com.yeejoin.amos.fas.business.action.model.ContingencyEvent;
import com.yeejoin.amos.fas.business.service.intfc.IRuleRunningSnapshotService;

@Component
public class ContingencyLogListener implements ApplicationListener<ContingencyEvent>{

	@Autowired
	IRuleRunningSnapshotService ruleRunningSnapshotService;

	@Override
	public void onApplicationEvent(ContingencyEvent event) {
		ruleRunningSnapshotService.reacordPlan(event.getTopic(), event.getMsgType(), event.getMsgBody(), event.getContingency());
	}

}
