package com.yeejoin.amos.fas.business.action.result.message;

import java.io.IOException;

import com.alibaba.fastjson.JSON;
import com.yeejoin.amos.fas.business.action.result.AbstractActionResult;
import com.yeejoin.amos.fas.business.action.result.ActionResult;
import com.yeejoin.amos.fas.business.action.websocket.RuleWebSocket;
import com.yeejoin.amos.fas.business.service.model.ToipResponse;
import com.yeejoin.amos.fas.business.util.Constants;
import com.yeejoin.amos.fas.core.util.CommonResponse;


public abstract class AbstractActionResultMessage<R extends ToipResponse>
		implements ActionResultMessage<ToipResponse>
{
	protected ActionResult actionResult;

	@Override
	public ToipResponse execute(String msgType,
			Object contingency) throws IOException, Exception
	{
		ToipResponse response = buildResponse(msgType, contingency,
				actionResult);
		if (!actionResult.getData().isEmpty())
		{
			sendResponse(response);
		}
		return response;
	}

	protected abstract Object getActionResultByDataFormat();

	/**
	 * 
	 * <pre>
	 * 构建对象
	 * </pre>
	 *
	 * @param viewTemp
	 * @param obj
	 * @return
	 */
	public ToipResponse buildResponse(String msgType, Object contingency, ActionResult msgContext)
	{
		ToipResponse toipResponse = new ToipResponse();
		toipResponse.setMsgType(msgType);
		toipResponse.setMsgContext(msgContext);
		toipResponse.setContingency(contingency);
		return toipResponse;
	}

	public ToipResponse buildResponse(String msgType, Object contingency, JSON msgContext)
	{
		ToipResponse toipResponse = new ToipResponse();
		toipResponse.setMsgType(msgType);
		toipResponse.setMsgContext(msgContext);
		toipResponse.setContingency(contingency);
		return toipResponse;
	}
	
	/**
	 * 
	 * <pre>
	 * 发送数据
	 * </pre>
	 *
	 * @param response
	 * @throws IOException
	 * @throws Exception
	 */
	protected void sendResponse(ToipResponse response)
			throws IOException, Exception
	{
		RuleWebSocket.sendInfo(response.toJsonStr());
		System.out.println("数据发送成功>>>>>>>>" + response.toJsonStr());
	}
}
