package com.yeejoin.amos.fas.business.action.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import com.alibaba.fastjson.JSONObject;
import com.yeejoin.amos.fas.business.action.el.ELEvaluationContext;

public class DataItemUtil
{
	public static boolean getEnable(JSONObject jsonObject)
	{
		try
		{
			return jsonObject.getBooleanValue("enable");
		}
		catch (Exception e)
		{
			return false;
		}
	}

	public static String getDisplayName(JSONObject jsonObject)
	{
		try
		{
			return jsonObject.get("displayname").toString();
		}
		catch (Exception e)
		{
			return null;
		}
	}

	public static String getValue(JSONObject jsonObject)
	{
		try
		{
			return jsonObject.get("value").toString();
		}
		catch (Exception e)
		{
			return null;
		}
	}

	public static String getName(JSONObject jsonObject)
	{
		try
		{
			return jsonObject.get("name").toString();
		}
		catch (Exception e)
		{
			return null;
		}
	}

	public static String getNative(String str)
	{
		Pattern p = Pattern.compile("\\{(.*?)\\}");
		Matcher m = p.matcher(str);
		while (m.find())
		{
			String parameter = m.group();

			Object parametervalue = ELEvaluationContext
					.getValue(parameter.substring(1, parameter.length() - 1));
			if(parametervalue != null)
				str = str.replace(parameter,
					parametervalue != null ? parametervalue.toString() : null);
		}
		return str;
	}
}
