package com.yeejoin.amos.fas.business.bo;

import com.alibaba.fastjson.JSONArray;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * @author suhg
 */
@ApiModel(description = "坐标实体(ue4及非ue4)")
public class BasePointPositionBo {
    /**
     * ue4点坐标
     */
    @ApiModelProperty("ue4坐标")
    private String ue4Location;
    /**
     * ue4旋转
     */
    @ApiModelProperty("ue4旋转")
    private String ue4Rotation;

    @ApiModelProperty("ue4缩放")
    private String ue4Extent;

    /**
     * 平台3维模型坐标
     */
    @ApiModelProperty("3d点坐标,非ue4用")
    private String position3d;
    
    @ApiModelProperty("区域坐标,非ue4用")
    private String routePath;

    public String getUe4Location() {
        return ue4Location;
    }

    public void setUe4Location(JSONArray ue4Location) {
        this.ue4Location = ue4Location.toString();
    }

    public String getUe4Rotation() {
        return ue4Rotation;
    }

    public void setUe4Rotation(JSONArray ue4Rotation) {
        this.ue4Rotation = ue4Rotation.toString();
    }

    public String getUe4Extent() {
        return ue4Extent;
    }

    public void setUe4Extent(JSONArray ue4Extent) {
        this.ue4Extent = ue4Extent.toString();
    }

    public String getPosition3d() {
        return position3d;
    }

    public void setPosition3d(String position3d) {
        this.position3d = position3d;
    }

	/**
	 * @return the routePath
	 */
	public String getRoutePath() {
		return routePath;
	}

	/**
	 * @param routePath the routePath to set
	 */
	public void setRoutePath(String routePath) {
		this.routePath = routePath;
	}
}
