package com.yeejoin.amos.fas.business.controller;

import com.yeejoin.amos.fas.business.util.ScheduledUtil;
import com.yeejoin.amos.fas.core.util.CommonResponse;
import com.yeejoin.amos.fas.core.util.CommonResponseUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping("/api/formInstance")
@Api(tags = "建筑API")
public class FormInstanceController extends BaseController {

    @Autowired
    private ScheduledUtil scheduledUtil;

    @ApiOperation(httpMethod = "GET", value = "消防水池与设备编码关系存入Redis", notes = "消防水池与设备编码关系存入Redis")
    @RequestMapping(value = "/saveWaterLevelToRedis", produces = "application/json;charset=UTF-8", method = RequestMethod.GET)
    public CommonResponse saveWaterLevelToRedis() {
        return CommonResponseUtil.success(scheduledUtil.saveWaterLevelToRedis());
    }

}
