package com.yeejoin.amos.fas.business.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.yeejoin.amos.component.feign.config.TokenOperation;
import com.yeejoin.amos.component.feign.model.FeignClientResult;
import com.yeejoin.amos.fas.business.feign.PrivilegeFeign;
import com.yeejoin.amos.fas.business.feign.RemoteSecurityService;
import com.yeejoin.amos.fas.business.vo.CompanyBo;
import com.yeejoin.amos.fas.business.vo.DepartmentBo;
import com.yeejoin.amos.fas.business.vo.ReginParams;
import com.yeejoin.amos.fas.business.vo.RoleBo;
import com.yeejoin.amos.feign.privilege.Privilege;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import com.yeejoin.amos.feign.privilege.model.ApplicationModel;
import com.yeejoin.amos.feign.privilege.model.CompanyModel;
import com.yeejoin.amos.feign.privilege.model.DepartmentModel;
import com.yeejoin.amos.feign.privilege.model.IdPasswordAuthModel;
import com.yeejoin.amos.feign.privilege.model.RoleModel;
import com.yeejoin.amos.feign.privilege.util.DesUtil;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.typroject.tyboot.component.cache.Redis;
import org.typroject.tyboot.component.cache.enumeration.CacheType;
import org.typroject.tyboot.core.foundation.context.RequestContext;

import javax.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

/**
 * @author zjw
 * @date 2020-03-30
 */

@RestController
@RequestMapping(value = "/api/loginBytoken")
@Api(tags = "通过userName登录Api")
public class LoginController {

    private static final Logger logger = LoggerFactory.getLogger(LoginController.class);

    @Autowired
    private PrivilegeFeign privilegeFeign;

    @Autowired
    private RedisTemplate<String, String> redisTemplate;

    @Autowired
    private RemoteSecurityService remoteSecurityService;

    @Value("${outSystem.user.password}")
    private String password;

    @Value("${amos.system.user.product}")
    private String product;

    @Value("${amos.system.user.app-key}")
    private String appKey;

    private String aProduct = "AMOS_STUDIO_WEB";
    private String bProduct = "AMOS-WEB-ADMIN";
    private String cProduct = "STUDIO_APP_3D";
    private String dProduct = "STUDIO_APP_MOBILE";
    private String eProduct = "STUDIO_APP_WEB";
    private String fProduct = "YHPATROL_WEB";



    @ApiOperation(value = "通过userId登录", notes = "查询设备指标")
    @GetMapping(value = "/{userId}")
    synchronized  public ReginParams getBindEquipment(@PathVariable("userId") String userId) throws Exception {

        if (ObjectUtils.isEmpty(userId)){
            throw new Exception("用户信息不存在");
        }
        HttpServletRequest request = ((ServletRequestAttributes) RequestContextHolder
                .getRequestAttributes()).getRequest();
        String token = "szhlz";
        		//ObjectUtils.isEmpty(request.getHeader("token"))?"szhlz":request.getHeader("token").toString() ;
        ReginParams reginParams;
        reginParams = JSON.parseObject(redisTemplate.opsForValue().get(buildKey(userId, token)), ReginParams.class);
        if(reginParams == null){
        	reginParams = getLogin(userId, token);
        }else{
        	RequestContext.setProduct(product);
            String cacheKey = Redis.genKey(new String[]{CacheType.ERASABLE.name(), "SESSION_TOKEN", aProduct, reginParams.getToken()});
            boolean hasKey = Redis.getRedisTemplate().hasKey(cacheKey);
            String cacheKey1 = Redis.genKey(new String[]{CacheType.ERASABLE.name(), "SESSION_TOKEN", bProduct, reginParams.getToken()});
            boolean hasKey1 = Redis.getRedisTemplate().hasKey(cacheKey1);
            String cacheKey2 = Redis.genKey(new String[]{CacheType.ERASABLE.name(), "SESSION_TOKEN", cProduct, reginParams.getToken()});
            boolean hasKey2 = Redis.getRedisTemplate().hasKey(cacheKey2);
            String cacheKey3 = Redis.genKey(new String[]{CacheType.ERASABLE.name(), "SESSION_TOKEN", dProduct, reginParams.getToken()});
            boolean hasKey3 = Redis.getRedisTemplate().hasKey(cacheKey3);
            String cacheKey4 = Redis.genKey(new String[]{CacheType.ERASABLE.name(), "SESSION_TOKEN", eProduct, reginParams.getToken()});
            boolean hasKey4 = Redis.getRedisTemplate().hasKey(cacheKey4);
            String cacheKey5 = Redis.genKey(new String[]{CacheType.ERASABLE.name(), "SESSION_TOKEN", fProduct, reginParams.getToken()});
            boolean hasKey5 = Redis.getRedisTemplate().hasKey(cacheKey5);
            if (hasKey && hasKey1 && hasKey2 && hasKey3 && hasKey4 && hasKey5) {
                return reginParams;
            } else {
                logger.info("Auto自动登陆=====:{}", JSON.toJSONString(reginParams));
                reginParams = getLogin(userId, token);
            }
        }
        return reginParams;
    }
    

	private   ReginParams getLogin(String userId, String token) throws Exception{
		 ReginParams reginParams = new ReginParams();
		 IdPasswordAuthModel  dPasswordAuthModel = new IdPasswordAuthModel();
         dPasswordAuthModel.setLoginId(userId);
         dPasswordAuthModel.setPassword(DesUtil.encode(password, "qaz"));
         RequestContext.setProduct(product);
 		FeignClientResult feignClientResult = Privilege.authClient.idpassword(dPasswordAuthModel);
         if (ObjectUtils.isEmpty(feignClientResult.getResult())){
             throw new Exception("缺失登录信息");
         }
         // 调用平台授权接口
         Map<String ,String > re = (Map<String, String>) feignClientResult.getResult();
         String amosToken = re.get("token");

        logger.info("应用授权开始======================================"+amosToken);
        RequestContext.setToken(amosToken);
        RequestContext.setProduct(product);
        RequestContext.setAppKey(appKey);

        List<ApplicationModel>  fd = Privilege.applicationClient.queryUserService().getResult();
//        FeignClientResult fd= privilegeFeign.warrant(appKey, product, amosToken);

        logger.info("应用授权结束======================================"+JSON.toJSONString(fd)+amosToken);

         AgencyUserModel userModel  =  (AgencyUserModel) Privilege.agencyUserClient.getme().getResult();
         CompanyModel companyModel = userModel.getCompanys().get(0);
         List<DepartmentModel> deptList = remoteSecurityService.getDepartmentTreeByCompanyId(amosToken, product, appKey, companyModel.getSequenceNbr().toString());
         if(deptList.size() > 0){
             CompanyBo companyBo = convertCompanyModelToBo(companyModel);
             DepartmentBo departmentBo = convertDepartmentModelToBo(deptList.get(0));
             reginParams.setDepartment(departmentBo);
             reginParams.setCompany(companyBo);
         }
         reginParams.setToken(amosToken);
         reginParams.setUserModel(userModel);
         redisTemplate.opsForValue().set(buildKey(userId, token), JSONObject.toJSONString(reginParams),28, TimeUnit.DAYS);
         // redisTemplate.opsForValue().set(buildKey(userId, amosToken), JSONObject.toJSONString(reginParams),28, TimeUnit.DAYS);
		return reginParams;
	}
	
	
    private DepartmentBo convertDepartmentModelToBo(DepartmentModel departmentModel){
        DepartmentBo departmentBo = new DepartmentBo();
        if(departmentModel != null) {
            departmentBo.setCompanySeq(departmentModel.getCompanySeq().toString());
            departmentBo.setDepartmentDesc(departmentModel.getDepartmentDesc());
            departmentBo.setDepartmentName(departmentModel.getDepartmentName());
            departmentBo.setLevel(departmentModel.getLevel());
            departmentBo.setOrgCode(departmentModel.getOrgCode());
            departmentBo.setParentId(departmentModel.getParentId().toString());
            departmentBo.setDeptOrgCode(departmentModel.getDeptOrgCode().toString());
            departmentBo.setSequenceNbr(departmentModel.getSequenceNbr().toString());
        }
        return departmentBo;
    }

    /**
     * 	Model 转 Bo
     */
    private CompanyBo convertCompanyModelToBo(CompanyModel companyModel){
        CompanyBo companyBo = new CompanyBo();
        if(companyModel != null) {
            companyBo.setAddress(companyModel.getAddress());
            companyBo.setCompanyName(companyModel.getCompanyName());
            companyBo.setCompanyOrgCode(Long.parseLong(companyModel.getCompanyOrgCode().toString()));
            companyBo.setEmail(companyModel.getEmail());
            companyBo.setLandlinePhone(companyModel.getLandlinePhone());
            companyBo.setLongitude(companyModel.getLongitude());
            companyBo.setLatitude(companyModel.getLatitude());
            companyBo.setLevel(companyModel.getLevel());
            companyBo.setOrgCode(companyModel.getOrgCode());
            companyBo.setSequenceNbr(companyModel.getSequenceNbr().toString());
            companyBo.setParentId(companyModel.getParentId().toString());
        }
        return companyBo;
    }

    private RoleBo convertRoleModelToBo(RoleModel roleModel) {
        RoleBo roleBo = new RoleBo();
        if(roleModel != null){
            roleBo.setRoleName(roleModel.getRoleName());
            roleBo.setRoleType(roleModel.getRoleType());
            roleBo.setSequenceNbr(roleModel.getSequenceNbr().toString());
        }
        return roleBo;
    }

    private String buildKey(String userId, String token) {
        return "region_" + userId + "_" + token;

    }
}
