package com.yeejoin.amos.fas.business.controller;

import com.yeejoin.amos.fas.business.service.intfc.IPlanMessageService;
import com.yeejoin.amos.fas.core.util.CommonResponse;
import com.yeejoin.amos.fas.core.util.CommonResponseUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * 预案报文 Controller 接口
 *
 * @author Gao Jianqiang
 * @date 2023-03-08
 */
@RestController
@RequestMapping(value = "/planMessage")
@Api(tags = "重点设备配套设施调整Api")

public class PlanMessageController extends BaseController {

    @Autowired
    private IPlanMessageService planMessageService;


    @ApiOperation(httpMethod = "GET", value = "获取预案指定步骤报文集合", notes = "获取预案指定步骤报文集合")
    @RequestMapping(value = "/getPlanMessageList", produces = "application/json;charset=UTF-8", method = RequestMethod.GET)
    public CommonResponse getPlanMessageList(@RequestParam String batchNo, @RequestParam Integer stepIndex) {
        return CommonResponseUtil.success(planMessageService.getPlanMessageList(batchNo, stepIndex));
    }

}
