package com.yeejoin.amos.fas.business.dao.repository;

import java.util.List;
import java.util.Optional;

import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.yeejoin.amos.fas.dao.entity.RiskFactor;

@Repository("iRiskFactorDao")
public interface IRiskFactorDao extends BaseDao<RiskFactor, Long> {

	List<RiskFactor> findByAccidentTypeId(Long id);
	
	@Modifying
	@Transactional
	@Query(value="delete from f_risk_factor where id in (?1)", nativeQuery = true)
	void deleteAllByIds(Long[] param);
	
	Optional<RiskFactor> findById(Long id);

}
