package com.yeejoin.amos.fas.business.feign;

import javax.servlet.http.HttpServletRequest;

import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import feign.RequestInterceptor;
import feign.RequestTemplate;

/**
 * @author DELL
 */
public class FeignBasicAuthRequestInterceptor implements RequestInterceptor{
	 public FeignBasicAuthRequestInterceptor() {

	    }

	    @Override
	    public void apply(RequestTemplate template) {
	    	ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
	    	if(attributes != null) {
	    		HttpServletRequest request = attributes.getRequest();
	        	/* Get token from header */
	        	String authToken = request.getHeader("X-Access-Token");
	        	/* If token not found get it from request parameter */
	        	if (authToken == null)
	        	{
	        		authToken = request.getHeader("token");
	        	}
	        	template.header("X-Access-Token", authToken);
	        	template.header("token", authToken);
	        	template.header("appKey", request.getHeader("appKey"));
            	template.header("product", request.getHeader("product"));
	        }
	    }
}
