package com.yeejoin.amos.fas.business.service.impl;

import java.util.HashMap;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.stereotype.Service;

import com.yeejoin.amos.fas.business.dao.mapper.AlarmMapper;
import com.yeejoin.amos.fas.business.param.CommonPageInfoParam;
import com.yeejoin.amos.fas.business.service.intfc.IAlarmService;
import com.yeejoin.amos.fas.core.util.StringUtil;

@Service("alarmService")
public class AlarmServiceImpl implements IAlarmService {
	
	@Autowired
	AlarmMapper alarmMapper;
	
	@Override
	public Page<HashMap<String, Object>> queryAlarmPage(CommonPageInfoParam param) {		
		long total = alarmMapper.countAlarmData(param);
		List<HashMap<String, Object>> content = alarmMapper.getAlarmSingleMapperPage(param);
		Page<HashMap<String, Object>> result = new PageImpl<>(content, param, total);
		return result;
	}

}
