package com.yeejoin.amos.fas.business.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.yeejoin.amos.fas.business.dao.mapper.EquipmentSpecificMapper;
import com.yeejoin.amos.fas.business.dao.mapper.FmeaEquipmentPointMapper;
import com.yeejoin.amos.fas.business.param.FmeaBindParam;
import com.yeejoin.amos.fas.business.service.intfc.EquipmentSpecificService;
import com.yeejoin.amos.fas.business.service.intfc.IEquipmentCategoryService;
import com.yeejoin.amos.fas.business.service.intfc.IFmeaService;
import com.yeejoin.amos.fas.business.util.TreeUtil;
import com.yeejoin.amos.fas.business.vo.AssoEquipsVo;
import com.yeejoin.amos.fas.business.vo.EquipmentPointVo;
import com.yeejoin.amos.fas.business.vo.EquipmentSpecificVo;
import com.yeejoin.amos.fas.dao.entity.EquipmentCategory;
import com.yeejoin.amos.fas.dao.entity.EquipmentSpecific;
import com.yeejoin.amos.fas.dao.entity.Fmea;
import com.yeejoin.amos.fas.dao.entity.FmeaEquipmentPoint;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.*;

/**
 * 装备配置 服务实现类
 *
 * @author zjw
 * @date 2020-11-04
 */
@Service("equipmentSpecificService")
public class EquipmentSpecificServiceImpl implements EquipmentSpecificService {

    @Autowired
    EquipmentSpecificMapper equipmentSpecificMapper;
    @Autowired
    IEquipmentCategoryService categoryService;
    @Autowired
    FmeaEquipmentPointMapper equipmentPointMapper;

    @Override
    public List<FmeaEquipmentPoint> upDateEquimentPoint(FmeaBindParam fmeaBindParam) {
        Long fmeaId = fmeaBindParam.getFmeaId();
        Long importantEquipId = fmeaBindParam.getImportantEquipmentId();
        equipmentSpecificMapper.deletPointBuFmeaId(fmeaId,importantEquipId);
        List<FmeaEquipmentPoint> returnList = new ArrayList<>();
        for (Long equipmentPointId : fmeaBindParam.getEquipmentPointIds()) {
            FmeaEquipmentPoint fmeaEquipmentPoint = new FmeaEquipmentPoint();
            fmeaEquipmentPoint.setFmeaId(fmeaId);
            fmeaEquipmentPoint.setImportantEquipmentId(importantEquipId);
            fmeaEquipmentPoint.setEquipmentPointId(equipmentPointId);
            returnList.add(fmeaEquipmentPoint);
        }
        if (!CollectionUtils.isEmpty(returnList)) {
            equipmentSpecificMapper.saveBatch(returnList);
        }
        return returnList;
    }

    @Override
    public Map<String, Object> getAssoEquips(Long fmeaId, int pageNumber, int pageSize) {
        Map<String, Object> map = new HashMap<>();
        pageNumber = pageNumber*pageSize;
        List<FmeaEquipmentPoint> fmeas = equipmentPointMapper.getOneByFmeaId(fmeaId);
        List<Long> indexIds = new ArrayList<>();
        if (0 < fmeas.size()) {
            for (FmeaEquipmentPoint point : fmeas) {
                Long indexId = equipmentSpecificMapper.getIndexByIndexId(point.getEquipmentPointId());
                indexIds.add(indexId);
            }
        }
        List<AssoEquipsVo> assoEquips = equipmentSpecificMapper.getAssoEquips(fmeaId, indexIds, pageNumber, pageSize);
        map.put("content",assoEquips);
        return map;
    }

    @Override
    public List<EquipmentPointVo> getBindEquipment(Long fmeaId, Long importantEquipId, Long equimentId, String equipmentPointName) {
        return equipmentSpecificMapper.getBindEquipment(fmeaId,importantEquipId,equimentId,equipmentPointName);
    }

    @Override
    public Map<String, List<EquipmentSpecificVo> > getFireEquiments(String equipmentId, String fname) {
        Map<String, List<EquipmentSpecificVo> > map = new HashMap<>();
        List<EquipmentSpecificVo> fireEquiments = equipmentSpecificMapper.getFireEquiments(equipmentId, fname);
        map.put("content",fireEquiments);
        return map;
    }

    @Override
    public Map<String, Object> getEquipmentBySpeV2(String name, int pageNumber, int pageSize, Long equipmentId) {
        Map<String, Object> map = new HashMap<>();
        List<Long> equipmentIdList = null;
        if (equipmentId != null) {
            List<EquipmentCategory> allChildren = TreeUtil.getAllChildren(categoryService.getAllTree(equipmentId));
            equipmentIdList = new LinkedList<>();
            equipmentIdList.add(equipmentId);
            if(!allChildren.isEmpty()){
                List<Long> finalEquipmentIdList = equipmentIdList;
                allChildren.forEach(cate -> finalEquipmentIdList.add(cate.getId()));
            }
        }
        List<EquipmentSpecificVo> equipmentBySpe = equipmentSpecificMapper.getEquipmentBySpe(pageNumber * pageSize, pageSize, name, null,null, equipmentIdList);
        int equipmentBySpeCount = equipmentSpecificMapper.getEquipmentBySpeCount(name, null,null, equipmentIdList);
        map.put("content",equipmentBySpe);
        map.put("totalElements",equipmentBySpeCount);
        return  map;
    }

    @Override
    public Map<String ,Object> getEquipmentBySpe(String name, String code, int pageNumber, int pageSize ,String equipmentId) {
        Map<String, Object> map = new HashMap<>();
        pageNumber = pageNumber*pageSize;
        code = checkid(code);
        List<EquipmentSpecificVo> equipmentBySpe = equipmentSpecificMapper.getEquipmentBySpe(pageNumber, pageSize, name, code,equipmentId, null);
        int equipmentBySpeCount = equipmentSpecificMapper.getEquipmentBySpeCount(name, code,equipmentId, null);
        map.put("content",equipmentBySpe);
        map.put("totalElements",equipmentBySpeCount);
        return  map;
    }

    /**
     * 截取装备分类code 码
     * @param id
     * @return
     */
    private String checkid(String id){
        if ("".equals(id) || "null".equals(id ) ){
            return id;
        }
        String substring = id.substring(1, 2);
        String substring1 = id.substring(2, 4);
        String substring2 = id.substring(4, 6);
        String substring3 = id.substring(6);
        if (!substring.equals("0")){
            substring = id.substring(0, 2);
            if (!substring1.equals("00")){
                substring += substring1;
                if(!substring2.equals("00")){
                    substring += substring2;
                    if(!substring3.equals("00")){
                        substring += substring3;
                    }
                }
            }
        }else {
            substring = id.substring(0, 1);
        }

        return substring+"%";
    }
}
