package com.yeejoin.amos.fas.business.vo;

import lombok.Data;

import java.util.List;
import java.util.Map;

/**
 * @ProjectName: YeeAmosFireAutoSysRoot
 * @Package: com.yeejoin.amos.fas.business.vo
 * @ClassName: FireStationVo
 * @Author: Jianqiang Gao
 * @Description: FireStationVo
 * @Date: 2021/5/18 11:45
 * @Version: 1.0
 */
@Data
public class FireStationVo {

    /**
     * id
     */
    private Long instanceId;

    /**
     * 名称
     */
    private String name;

    /**
     * 编号
     */
    private String code;

    /**
     * 类型 1：消防小室，2：消防泡沫间
     */
    private String type;

    /**
     * 所属风险区域id
     */
    private Long riskSourceId;

    /**
     * 位置
     */
    private String address;

    private List<Map> fireEquipmentInfo;

    /**
     * 实时液位(m)
     */
    private String level;

}