package com.yeejoin.amos.fas.business.controller;


import com.alibaba.fastjson.JSONObject;
import org.springframework.data.domain.Page;
import com.yeejoin.amos.fas.business.dao.mapper.EmergencyTaskMapper;
import com.yeejoin.amos.fas.business.dao.mapper.EmergencyTaskRoleMapper;
import com.yeejoin.amos.fas.business.feign.JcsFeign;
import com.yeejoin.amos.fas.business.service.intfc.IDictService;
import com.yeejoin.amos.fas.business.service.intfc.IEmergencyTaskService;
import com.yeejoin.amos.fas.business.service.intfc.IPlanStepService;
import com.yeejoin.amos.fas.business.vo.EmergencyRelationVo;
import com.yeejoin.amos.fas.business.vo.PlanStepJsonVO;
import com.yeejoin.amos.fas.config.Permission;
import com.yeejoin.amos.fas.core.common.request.CommonPageable;
import com.yeejoin.amos.fas.core.util.CommonResponse;
import com.yeejoin.amos.fas.core.util.CommonResponseUtil;
import com.yeejoin.amos.fas.core.util.CommonResponseUtil2;
import com.yeejoin.amos.fas.core.util.ResponseModel;
import com.yeejoin.amos.fas.dao.entity.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

@Controller
@RequestMapping("/api/emergency")
@Api(tags = "应急人员分工Api")
public class EmergencyTaskController extends BaseController{

    @Autowired
    JcsFeign jcsFeign;

    @Lazy
    @Autowired
    IEmergencyTaskService iEmergencyTaskService;

    @Autowired
    private IDictService dictService;

    @Autowired
    private RedisTemplate redisTemplate;

    @Autowired
    private EmergencyTaskRoleMapper emergencyTaskRoleMapper;

    @Autowired
    private EmergencyTaskMapper emergencyTaskMapper;

    @Autowired
    private IPlanStepService planStepService;

    @ApiOperation(httpMethod = "GET",value = "岗位人员树", notes = "岗位人员树")
    @RequestMapping(value = "/tree", method = RequestMethod.GET)
    public CommonResponse tree(@RequestParam(value = "type", required = false) String type){
        Dict dict = new Dict();
        dict.setDictCode("YJZC");
        //查询应急角色
//        List<Dict> dictList = dictService.getDictList(dict);
        List<EmergencyTaskRole> emergencyTaskRoles = new ArrayList<>();
        if (StringUtils.isNotEmpty(type)) {
            emergencyTaskRoles = emergencyTaskRoleMapper.selectListFilterEmptyTask();
        } else {
            emergencyTaskRoles = emergencyTaskRoleMapper.selectList();
        }
        List<EmergencyRelationTree> list = new ArrayList<>();
        List<EmergencyRelationTree> root = new ArrayList<>();
        List<EmergencyRelationTree> treeNodes = iEmergencyTaskService.treeList();

        //组装对应人员节点
        emergencyTaskRoles.forEach(e->{
            EmergencyRelationTree tree = new EmergencyRelationTree();
            tree.setId(e.getId());
            tree.setName(e.getName());
            tree.setType("0");
            tree.setSequenceNbr(String.valueOf(e.getId()));
            tree.setCode(e.getCode());
            tree.setChildren(treeNodes.stream().filter(t->t.getObligationId().equals(e.getId())).collect(Collectors.toList()));
            list.add(tree);
        });

        //增加根节点
        EmergencyRelationTree tree = new EmergencyRelationTree();
        tree.setId(0);
        tree.setSequenceNbr("0");
        tree.setName("全部");
        tree.setType("3");
        tree.setCode("0");
        tree.setChildren(list);

        root.add(tree);
        return CommonResponseUtil.success(root);
    }


    @ApiOperation(httpMethod = "GET",value = "分工内容列表", notes = "分工内容列表")
    @RequestMapping(value = "/list", method = RequestMethod.GET)
    public CommonResponse list(Long obligationId , @RequestParam(required = false) String planType,@RequestParam int pageNumber,
                               @RequestParam  int pageSize){
        if (pageNumber >=1 ){
            pageNumber = pageNumber -1 ;
        }
        if(obligationId == 0){
            obligationId = null;
        }
        CommonPageable commonPageable = new CommonPageable(pageNumber, pageSize);

        if (StringUtils.isNotEmpty(planType) && "0".equals(planType)) {
            planType = null;
        }
        Page<EmergencyTaskContent> list = iEmergencyTaskService.list(obligationId, planType, commonPageable);
        return CommonResponseUtil.success(list);
    }


    @ApiOperation(httpMethod = "POST",value = "树人员节点删除", notes = "树人员节点删除")
    @RequestMapping(value = "/deleteTreeNode", method = RequestMethod.DELETE)
    public CommonResponse deleteTreeNode(Long obligationId ,Long id){
        iEmergencyTaskService.deleteTreeNode(obligationId,id);
        return CommonResponseUtil.success();
    }


    @ApiOperation(httpMethod = "POST",value = "新增树人员节点", notes = "新增树人员节点")
    @PostMapping(value = "/savePerson", produces = "application/json;charset=UTF-8")
    public CommonResponse savePerson(@RequestBody EmergencyRelationVo vo){
        List<Long> personIds = vo.getPersonIds();
        List<Long> oldPersonIds = iEmergencyTaskService.getPersonIds(vo.getObligationId());

        String ids = StringUtils.join(oldPersonIds, ",");


        List<Object> objects = jcsFeign.listCompanyByIds(personIds);
        StringBuffer stringBuffer = new StringBuffer();
        for (Object e : objects) {
            String json = JSONObject.toJSONString(e);
            JSONObject jsonObject = JSONObject.parseObject(json);
            if (ids.contains(jsonObject.get("sequenceNbr").toString())){
                stringBuffer.append(jsonObject.get("bizOrgName").toString()+" ");
                continue;
            }
            EmergencyRelation emergencyRelation = new EmergencyRelation();
            emergencyRelation.setObligationId(vo.getObligationId());
            emergencyRelation.setPersonId(Long.valueOf(jsonObject.get("sequenceNbr").toString()));
            emergencyRelation.setPersonName(jsonObject.get("bizOrgName").toString());
            emergencyRelation.setAmosOrgId(Long.valueOf(jsonObject.get("amosOrgId").toString()));
            emergencyRelation.setCreateDate(new Date());
            iEmergencyTaskService.save(emergencyRelation);
        }
        if (stringBuffer.length()>0){
            stringBuffer.append("已存在");
            return CommonResponseUtil.failure(stringBuffer.toString());
        }



        return CommonResponseUtil.success();
    }

    @ApiOperation(httpMethod = "POST",value = "新增应急任务配置", notes = "新增应急任务配置")
    @PostMapping(value = "/saveTaskConfig", produces = "application/json;charset=UTF-8")
    public ResponseModel saveTaskConfig(@RequestBody EmergencyTaskContent emergencyTaskContent){
        iEmergencyTaskService.saveTaskConfig(emergencyTaskContent);
        return CommonResponseUtil2.success();
    }


    @ApiOperation(httpMethod = "GET",value = "查询流程节点", notes = "查询流程节点")
    @GetMapping(value = "/findStep")
    public ResponseModel<List<PlanStepJsonVO>> findStep(@RequestParam String planType){
        return CommonResponseUtil2.success(planStepService.getPlanStepByParam(planType));
    }

    @Permission
    @ApiOperation(value = "根据ID删除数据", notes = "根据ID删除数据")
    @DeleteMapping(value = "/deleteById", produces = "application/json;charset=UTF-8")
    public ResponseModel deleteById(@RequestParam(value = "id") Long id) {
        if (!Objects.isNull(id)) {
            emergencyTaskMapper.deleteTask(id);
        }
        return CommonResponseUtil2.success();
    }

    @ApiOperation(httpMethod = "POST",value = "编辑树人员节点", notes = "编辑树人员节点")
    @PostMapping(value = "/editPerson", produces = "application/json;charset=UTF-8")
    public CommonResponse editPerson(@RequestBody EmergencyRelationVo vo){

        this.deleteTreeNode(vo.getObligationId(), null);
        List<Long> personIds = vo.getPersonIds();
        List<Object> objects = jcsFeign.listCompanyByIds(personIds);
        objects.forEach(e->
                {
                    String json = JSONObject.toJSONString(e);
                    JSONObject jsonObject = JSONObject.parseObject(json);
                    EmergencyRelation emergencyRelation = new EmergencyRelation();
                    emergencyRelation.setObligationId(vo.getObligationId());
                    emergencyRelation.setPersonId(Long.valueOf(jsonObject.get("sequenceNbr").toString()));
                    emergencyRelation.setPersonName(jsonObject.get("bizOrgName").toString());
                    emergencyRelation.setAmosOrgId(Long.valueOf(jsonObject.get("amosOrgId").toString()));
                    emergencyRelation.setCreateDate(new Date());
                    iEmergencyTaskService.save(emergencyRelation);
                }
        );
        return CommonResponseUtil.success();
    }


    @ApiOperation(httpMethod = "GET",value = "获取当前节点绑定人员", notes = "获取当前节点绑定人员")
    @RequestMapping(value = "/getPersons", method = RequestMethod.GET)
    public CommonResponse getPersons(@RequestParam Long obligationId){

        EmergencyRelationVo emergencyRelationVo = new EmergencyRelationVo();
        emergencyRelationVo.setPersonIds(iEmergencyTaskService.getPersonIds(obligationId));
        return CommonResponseUtil.success(emergencyRelationVo);
    }

    @ApiOperation(httpMethod = "POST",value = "新增流程任务", notes = "新增流程任务")
    @PostMapping(value = "/task/add", produces = "application/json; charset=UTF-8")
    public CommonResponse addTaskContent(@RequestBody String stepCode){
        iEmergencyTaskService.saveTask(stepCode, null);
        return CommonResponseUtil.success();
    }

}
