package com.yeejoin.amos.fas.business.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.fas.business.dao.mapper.PlanReportMapper;
import com.yeejoin.amos.fas.business.service.intfc.IPlanReportService;
import com.yeejoin.amos.fas.business.vo.ReginParams;
import com.yeejoin.amos.fas.config.Permission;
import com.yeejoin.amos.fas.core.util.CommonResponse;
import com.yeejoin.amos.fas.core.util.CommonResponseUtil;
import com.yeejoin.amos.fas.dao.entity.PlanReport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Date;

@RestController
@RequestMapping(value = "/planReport")
@Api(tags = "演练报告API")
public class PlanReportController extends BaseController {
    @Autowired
    PlanReportMapper planReportMapper;

    @Autowired
    IPlanReportService iPlanReportService;

    /**
     * 保存站端信息
     */
    @Permission
    @ApiOperation(value = "保存API", notes = "保存API")
    @PostMapping(value = "/save")
    public CommonResponse saveStation(@RequestBody PlanReport planReport) {
        ReginParams reginParams = getSelectedOrgInfo();
        String bizOrgCode = reginParams.getCompany().getOrgCode();
        String bizOrgName = reginParams.getCompany().getCompanyName();
        planReport.setBizOrgCode(bizOrgCode);
        planReport.setBizOrgName(bizOrgName);
        planReport.setCreateDate(new Date());
        planReport.setDrillDate(new Date());
        planReportMapper.saveInfo(planReport);
        return CommonResponseUtil.success(planReport);
    }

    /**
     * 保存站端信息
     */
    @Permission
    @ApiOperation(value = "删除API", notes = "删除API")
    @PostMapping(value = "/deleteById")
    public CommonResponse deleteById(@RequestParam(value = "id") Long id) {
        planReportMapper.deleteById(id);
        return CommonResponseUtil.success();
    }

    /**
     * 保存站端信息
     */
    @Permission
    @ApiOperation(value = "详情API", notes = "详情API")
    @GetMapping(value = "/getById")
    public CommonResponse getById(@RequestParam(value = "id") Long id) {
        PlanReport planReport = planReportMapper.getById(id);
        return CommonResponseUtil.success(planReport);
    }

    /**
     * 保存站端信息
     */
    @Permission
    @ApiOperation(value = "分页查询", notes = "分页查询")
    @PostMapping(value = "/getByPage")
    public CommonResponse getByPage(@RequestBody PlanReport planReport) {
        Page<PlanReport> resultPage = iPlanReportService.getByPage(planReport);
        return CommonResponseUtil.success(resultPage);
    }

    @Permission
    @ApiOperation(value = "更新", notes = "更新")
    @PutMapping(value = "/update", produces = "application/json;charset=UTF-8")
    public CommonResponse updateReport(@RequestBody PlanReport planReport) {
        PlanReport report = iPlanReportService.updateReport(planReport);
        return CommonResponseUtil.success(report);
    }

    @Permission
    @ApiOperation(value = "下载报告", notes = "下载报告")
    @GetMapping(value = "/download")
    public void download(HttpServletRequest request, HttpServletResponse response,
                         @ApiParam(value = "id", required = true) @RequestParam String id) {
        iPlanReportService.download(request, response, id);
    }

    @Permission
    @ApiOperation(value = "预览报告", notes = "预览报告")
    @GetMapping(value = "/preview")
    public CommonResponse preview(
            @ApiParam(value = "id", required = true) @RequestParam String id) {
        PlanReport report = planReportMapper.getById(Long.valueOf(id));
        return CommonResponseUtil.success(iPlanReportService.preview(report));
    }

}
