package com.yeejoin.amos.fas.business.dao.mapper;

import com.yeejoin.amos.fas.business.vo.EmergencyTaskContentVo;
import com.yeejoin.amos.fas.dao.entity.EmergencyRelation;
import com.yeejoin.amos.fas.dao.entity.EmergencyRelationTree;
import com.yeejoin.amos.fas.dao.entity.EmergencyTaskContent;
import org.apache.ibatis.annotations.Param;

import java.util.List;

public interface EmergencyTaskMapper extends BaseMapper {
    List<EmergencyTaskContent> getEmergencyTaskList(@Param("obligationId") Long obligationId, @Param("offset")Long  offset,  @Param("pageSize")int pageSize, @Param("planType") String planType);
    int getEmergencyTaskCount(@Param("obligationId") Long obligationId, @Param("planType") String planType);

    List<EmergencyRelationTree> treeList();

    void deleteTreeNode(Long obligationId , Long personId);


    void deleteTask(@Param("id") Long id);


    void save(EmergencyRelation emergencyRelation);

    void saveTaskConfig(EmergencyTaskContent emergencyTaskContent);

    List<String> roleCodes(String amosOrgId);

    List<Long> getPersonIds(Long obligationId);

    List<String> roleNames(String amosOrgId);

    List<EmergencyTaskContentVo> getContentList(@Param("stepCode") String stepCode, @Param("planType") String planType);

    List<EmergencyTaskContentVo> getMustTaskList(@Param("stepCode") String stepCode, @Param("planType") String planType);

}
