package com.yeejoin.amos.fas.business.dao.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.yeejoin.amos.fas.dao.entity.EmergencyTaskRole;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

@Mapper
public interface EmergencyTaskRoleMapper extends BaseMapper<EmergencyTaskRole> {

    void save(EmergencyTaskRole emergencyTaskRole);

    int countByCode(String code);

    int updateById(EmergencyTaskRole emergencyTaskRole);

    EmergencyTaskRole selectById(Long id);

    int getInfoCount(EmergencyTaskRole emergencyTaskRole);

    List<EmergencyTaskRole> getInfoByPage(Integer pageNum,
                                          Integer size,
                                          EmergencyTaskRole emergencyTaskRole);

    int deleteById(Long id);

    int deleteRelationByRoleId(Long roleId);

    EmergencyTaskRole selectByCode(String code);

    List<EmergencyTaskRole> selectList();

    List<EmergencyTaskRole> selectListFilterEmptyTask();

    String getPlanStepInfoByType(@Param("planType") String planType);

    String getLastPlanStepInfo();

    void updatePlanStepByPlanType(@Param("planType") String planType, @Param("planStepJson") String planStepJson);

    Map<String, String> queryPlanStepByEquipCode(@Param("equipCode") String equipCode);
}
